class Summry extends Id {

static int indx[] = new int[SORTSZE];
static int freq[] = new int[100];

static double dat[] = new double[SORTSZE];

// -----------------------------------------------------------------------

static int mode_(int n, double prob[]) {

// Returns the mode of a discrete distribution.

int i, mode = 0;

double maxprob = 0., sumprob = 0.;

for (i = 0; i < n; ++i) {
   sumprob += prob[i];
   if (prob[i] > maxprob) {
      maxprob = prob[i];
      mode = i + 1;
   }
}

// Error checks.

if (mode == 0 || Math.abs(1. - sumprob) > 1.e-6) {
   for (i = 0; i < n; ++i) {
      printf_("mode: i= " + i + " probability= " + prob[i]);
   }
   iderr_("mode: sumprob= " + sumprob + " mode= " + mode);
}

return mode;
}

// ------------------------------------------------------------------------

static double coefvar_(int n, double data[]) {

// Computes the Coefficient of Variation.

int i;

double mean = 0., smplvr = 0., rn = 0., coefvar = 0.;

if (n < 2) {
   printf_("coefvar: n= " + n);
   return 0.;
}

// Compute mean and standard deviation.

rn = (double) n;
for (i = 0; i < n; ++i) {
   mean += data[i];
   smplvr += data[i] * data[i];
   indx[i] = i + 1;
}
smplvr = (smplvr - ((mean * mean) / rn)) / (rn - 1.);
mean /= rn;

if (smplvr < 1.e-6) {
   coefvar = 0.;

} else if (Math.abs(mean) < 1.e-6) {
   coefvar = Math.sqrt(smplvr) / (mean + 1.);

} else {
   coefvar = Math.sqrt(smplvr) / mean;
}

// Find max, min.

/*
Idsort.idsort_(data, indx, 1, n);
printf_("coefvar: min= " + data[0] + " max= " + data[n - 1]);
*/

return coefvar;
}

// -----------------------------------------------------------------------

static void summry_(boolean pflag, int stdtype, int n[], int nmvar,
   double trimfrac[], double data[][], double meanvec[], double stdvec[],
   double maxvec[]) {

/* Computes summary statistics.
   stdtype = 1: Sample standard deviation
   stdtype = 2: ADMED
   stdtype = 3: IQR */

int i, j, start, end;

double rn, diff, median, admed;

// Initialize trimmed mean, trimmed standard deviation, and maximum vectors.

for (i = 0; i < nmvar; ++i) {
   meanvec[i] = 0.;
   stdvec[i] = 0.;
   maxvec[i] = 0.;
}

// Defensive programming.

for (i = 0; i < nmvar; ++i) {
   if (n[i] <= 0) {
      printf_("summry: i= " + i + " n= " + n[i]);
      return;
   }
}

// Compute trimmed mean and maximum on each variable.

for (j = 0; j < nmvar; ++j) {
   if (n[j] < 3) {
      printf_("summry: n(" + (j + 1) + ") < 3, no mean or std. dev.");
      continue;
   }
   for (i = 0; i < n[j]; ++i) {
      dat[i] = data[i][j];
      indx[i] = i + 1;
      if (maxvec[j] < dat[i]) maxvec[j] = dat[i];
   }
   Idsort.idsort_(dat, indx, 1, n[j]);
   start = (int) (((double) n[j]) * trimfrac[j]);
   end = n[j] - start;
   rn = (double) (n[j] - 2 * start);
   for (i = start; i < end; ++i) {
      meanvec[j] += dat[i];
   }
   meanvec[j] /= rn;

   // Compute trimmed standard deviation.

   if (n[j] < 2) {
      continue;
   }
   for (i = start; i < end; ++i) {
      diff = dat[i] - meanvec[j];
      stdvec[j] += diff * diff;
   }
   stdvec[j] = Math.sqrt(stdvec[j] / (rn - 1.));
   if (stdvec[j] == 0.) {
      stdvec[j] = 1.e-10;
   }

   if (pflag) {
      fprintf_(1, "summry: variable= " + (j + 1) + " mean= " +
	 meanvec[j] + " std= " + stdvec[j]);
   }
}
if (stdtype == 1) {
   return;
}

// Compute alternate dispersion statistics.

for (j = 0; j < nmvar; ++j) {
   if (n[j] < 3) {
      continue;
   }
   rn = (double) n[j];
   for (i = 0; i < n[j]; ++i) {
      dat[i] = data[i][j];
      indx[i] = i + 1;
   }
   Idsort.idsort_(dat, indx, 1, n[j]);
   if (n[j] != 2 * (n[j] / 2)) {
      median = dat[n[j] / 2];

   } else {
      median = .5 * (dat[n[j] / 2  - 1] + dat[n[j] / 2]);
   }

   if (stdtype == 2) {
   
      /* Compute the median and the ADMED (Average Deviation from the
         Median, a robust measure of scale and hence an alternative to
         the standard deviation). */

      admed = 0.;
      for (i = 0; i < n[j]; ++i) {
	 admed += Math.abs(dat[i] - median);
      }
      admed /= rn;
      stdvec[j] = admed;
      meanvec[j] = median;
   }

   if (stdtype == 3) {

      // Interquartile Range.

      if (n[j] > 4) {
	 stdvec[j] = dat[(3 * n[j] / 4) - 1] - dat[(n[j] / 4) - 1];

      } else {
	 stdvec[j] = dat[n[j] - 1] - dat[0];
      }
   }
}
}

// ----------------------------------------------------------------------

static void moments_(boolean wflag, int n, double dat[], double moments[]) {

// Computes the first 4 sample moments.  See Madansky 1988, p. 37.

int i, sktype = 1;
double mean = 0., diff, diff2, diff3, diff4, m2 = 0., m3 = 0., m4 = 0.,
   rn, var, skew, kurtosis, median;

rn = (double) n;
for (i = 0; i < n; ++i) {
   mean += dat[i];
}
mean /= rn;

for (i = 0; i < n; ++i) {
   diff = dat[i] - mean;
   diff2 = diff * diff;
   diff3 = diff * diff2;
   diff4 = diff2 * diff2;
   m2 += diff2;
   m3 += diff3;
   m4 += diff4;
}
var = m2 / (rn - 1.);
if (var < 1.e-20) {
   iderr_("summry: n= " + n + " var=0");
}
skew = Math.sqrt(rn) * m3 / Math.pow(m2, 1.5);
kurtosis = (rn * m4 / (m2 * m2)) - 3.;

if (sktype == 2) {

   // Gupta's skew statistic.

   for (i = 0; i < n; ++i) {
      indx[i] = i + 1;
   }
   Idsort.idsort_(dat, indx, 1, n);
   median = dat[n / 2];
   skew = Describe.gupskew_(n, median, dat);
}

if (wflag) {
   fprintf_(1, "moments: mean= " + mean + " variance= " + var +
      "\n      skew= " + skew + " kurtosis= " + kurtosis);
}

moments[0] = mean;
moments[1] = var;
moments[2] = skew;
moments[3] = kurtosis;
}

// ----------------------------------------------------------------------

static double quantile_(int n, double dat[], double frctn) {

// Computes the 100*frctn% sample quantile of the sorted data in "dat."

int i, ival;

double testval, rn, rnp, quantile;

if (n > SORTSZE) {
   iderr_("quantile: n= " + n + " > SORTSZE");

} else if (n <= 0) {
   iderr_("quantile: n= " + n);
}

// Test for "rnp" being an integer.

rn = (double) n;
rnp = rn * frctn;
testval = 2.0 * Math.floor(rnp / 2.0);
if ((rnp - testval) > 1.e-6) {
   ival = ((int) rnp) + 1;

} else {
   ival = (int) rnp;
}

if (ival == 0) {
   ival = 1;
}
if (ival > n) {
   ival = n;
}

for (i = 0; i < n; ++i) {
   indx[i] = i + 1;
}
Idsort.idsort_(dat, indx, 1, n);

quantile = dat[ival - 1];

return quantile;
}

// ----------------------------------------------------------------------

static double entvar_(int n, double freq[]) {

/* Compute the entropy-based dispersion measure of a nominally-valued
   distribution.  See Wilcox, A. R. (1973), ``Indices of Qualitative
   Variation and Political Measurement,'' The Western Political
   Quarterly, 26: 325-343.

\begin{equation}
V = \frac{1}{\ln{n}}\sum_{i=1}^n f_i \ln{f_i}
\end{equation}
*/

int i;

double entvar = 0.;

if (n == 1) {
   return 0.;
}

for (i = 0; i < n; ++i) {
   entvar += freq[i] * Math.log(freq[i]);
}
entvar /= Math.log((double) n);

return (-entvar);
}

// ----------------------------------------------------------------------

static int smplmode_(int n, int dat[]) {

// Finds the sample mode.

int i, nmvals = 0, maxfreq = 0, smplmode = 0;

for (i = 0; i < n; ++i) {
   if (dat[i] > nmvals) {
      nmvals = dat[i];
   }
}

for (i = 0; i < 100; ++i) {
   freq[i] = 0;
}

for (i = 0; i < n; ++i) {
   ++freq[dat[i] - 1];
}

for (i = 0; i < nmvals; ++i) {
   if (freq[i] > maxfreq) {
      smplmode = i + 1;
      maxfreq = freq[i];
   }
}

return (smplmode);
}
}
