class Surf extends Id {

// Main class for spatio-temporal analyses.

static boolean lngmem = false, itest = false, negest, covrd, nonlin,
   odefirst, frstfit, grdstre, simdat = false, xislongitude = false;

static boolean inregn[] = new boolean[MAXNMBPT];

static String coeffname[] = new String[NMWRPAR];

static int quantvarmodel, nmpenreg, addsts, nmest, icrval, grow, gcol,
   sbrgnnm, nmquantvar, nmqualvar, jtime, idatcr, nmmdls, nmtrendpars,
   ndi, iblank, ttlnmpars, nd, nmstmixcntr = 0, covnonstatmdl = 0,
   krnlstart = 0, krnlend = 0, parm_mrow, parm_mcol, parm_mtot, dum = 0;

static int ndmin[] = new int[NUMVAR];
static int nmsites[] = new int[NUMVAR];
static int siteonoff[] = new int[DATSZE];
static int nmcylobs[] = new int[NUMVAR];
static int nmpars[] = new int[NUMVAR];
static int nmquallvl[] = new int[NMQUAL];
static int quantvarnms[][] = new int[NUMVAR][NMQUANT];
static int qualvarnms[][] = new int[NUMVAR][NMQUAL];
static int crossmap[][] = new int[NUMVAR][NUMVAR];
static int deldst[] = new int[SIMASZE];

static double pas, tol, past, rpnlty, netrpnlty, xmean, ymean, minx, miny,
   mcheps, saltol, fpmin, ceven, codd, da, tolt, r2, pvol, chisqd, chisqc,
   xshift, yshift, xscale, yscale, clpxmin, area, clpxmax, clpymin, clpymax;

static double xvals[][] = new double[NUMVAR][DATSZE];
static double yvals[][] = new double[NUMVAR][DATSZE];
static double datfrac[] = new double[NUMVAR];
static double tlngth[] = new double[NUMVAR];
static double glblmean[] = new double[NUMVAR];
static double glblsmplvr[] = new double[NUMVAR];
static double glblsst[] = new double[NUMVAR];
static double resmse[] = new double[NUMVAR];
static double alp[] = new double[2];
static double lags[] = new double[LGDIM + 1];
static double lagt[][] = new double[2][LGDIM + 1];
static double c[][] = new double[WLSSZE][NMWRPAR];
static double cstore[][] = new double[WLSSZE][NMWRPAR];
static double form_a[][] = new double[WLSSZE2][WLSSZE2];
static double s[][] = new double[WLSSZE2][WLSSZE2];
static double form_xmeas[][] = new double[WLSSZE][NUMVAR + 1];
static double prdloc[][] = new double[DATSZE][3];
static double wght[][][] = new double[NUMMDLS][LGDIM + 1][2 * LGDIM + 1];
static double realmmts[][] = new double[NUMVAR][4];

// Data structures.

static int vardat_vrble[] = new int[DATSZE];
static int vardat_steid[] = new int[DATSZE];
static double vardat_x[] = new double[DATSZE];
static double vardat_y[] = new double[DATSZE];
static double vardat_t[] = new double[DATSZE];
static double vardat_obs[] = new double[DATSZE];
static double vardat_quantval[][] = new double[DATSZE][NMQUANT];
static int vardat_qualval[][] = new int[DATSZE][NMQUAL];
static double vardat_dat[] = new double[DATSZE];
static double vardat_trend[] = new double[DATSZE];
static double vardat_stdres[] = new double[DATSZE];

static int trnsfrm_nmpars;
static double trnsfrm_tau1[] = new double[NUMVAR];
static double trnsfrm_tau2[] = new double[NUMVAR];
static double trnsfrm_invtau1[] = new double[NUMVAR];
static double trnsfrm_invtau2[] = new double[NUMVAR];

// Position 0 on the nugget, sill, range is for local models.

static int varmod_ifail, varmod_nmpars;
static int varmod_model[] = new int[NUMMDLS];
static double varmod_epsln, varmod_rngelim, varmod_swght = .1;
static double varmod_radius[] = new double[NUMVAR];
static double varmod_nugget[][] = new double[NUMCNTR + 1][NUMMDLS];
static double varmod_sill[][] = new double[NUMCNTR + 1][NUMMDLS];
static double varmod_range[][][] = new double[NUMCNTR + 1][2][NUMMDLS];
static double varmod_oddnug[][] = new double[NUMCNTR + 1][NUMMDLS];
static double varmod_oddsill[][] = new double[NUMCNTR + 1][NUMMDLS];
static double varmod_oddrnge[][] = new double[NUMCNTR + 1][NUMMDLS];
static double varmod_anis[] = new double[NUMMDLS];
static double varmod_ratio[] = new double[NUMMDLS];
static double varmod_mean[] = new double[NUMVAR];
static double varmod_smplvr[] = new double[NUMVAR];
static double varmod_ttlvar[] = new double[NUMVAR];
static double varmod_nonstat[] = new double[3];
static double varmod_avegam2[] = new double[NUMMDLS];
static double varmod_lma[] = new double[NUMMDLS];
static double varmod_lmb[] = new double[NUMMDLS];
static double varmod_lmc[] = new double[NUMMDLS];

static double stmix_xcntr[] =   new double[NUMCNTR];
static double stmix_ycntr[] =   new double[NUMCNTR];
static double stmix_tcntr[] =   new double[NUMCNTR];
static double stmix_krnlvar[] = new double[NUMCNTR];
static double stmix_rparm[][][] = new double[NUMCNTR][NUMVAR][NMWRPAR];

static int    gama_nc[][][][] = new int[LGDIM + 1][2][2 * LGDIM + 1][NUMMDLS];
static double gama_g[][][][] =
                             new double[LGDIM + 1][2][2 * LGDIM + 1][NUMMDLS];
static double gama_geven[][][][] =
                             new double[LGDIM + 1][2][2 * LGDIM + 1][NUMMDLS];
static double gama_godd[][][][] =
                             new double[LGDIM + 1][2][2 * LGDIM + 1][NUMMDLS];
static double gama_d[][][][] =
                             new double[LGDIM + 1][2][2 * LGDIM + 1][NUMMDLS];

static int    grdvar_iblank[][][] = new int[ROWLIM][COLLIM][MAXTIMES];
static double grdvar_krgvar[][][] = new double[ROWLIM][COLLIM][MAXTIMES];
static double grdvar_est[][][][] =
                                  new double[ROWLIM][COLLIM][MAXTIMES][NUMVAR];
static double grdvar_x[][][] = new double[ROWLIM][COLLIM][MAXTIMES];
static double grdvar_y[][][] = new double[ROWLIM][COLLIM][MAXTIMES];
static double grdvar_t[][][] = new double[ROWLIM][COLLIM][MAXTIMES];
static double grdvar_radius, grdvar_datmn, grdvar_datssy, grdvar_datsvar,
   grdvar_vm, grdvar_vr;

static double grdvar_vrblemns[] = new double[NUMVAR];
static double grdvar_seasmns[][] = new double[NUMVAR][4];

static double grdvar_nug[][][][] =
                            new double[ROWLIM][COLLIM][MAXTIMES][NUMMDLS];
static double grdvar_sill[][][][] =
                            new double[ROWLIM][COLLIM][MAXTIMES][NUMMDLS];
static double grdvar_rnge[][][][][] =
                          new double[ROWLIM][COLLIM][MAXTIMES][2][NUMMDLS];
static double grdvar_g[] = new double[LGDIM + 1];
static double grdvar_trend[][][][] =
                          new double[ROWLIM][COLLIM][MAXTIMES][NUMVAR];
static double grdvar_rparm[][] = new double[NUMVAR][NMWRPAR];

// ---------------------------------------------------------------------

static void surf_() {

// Sets up spatial, temporal, or space-time analyses.

boolean fitglobalparameters = false;

int i, j, nmskip = 1, ndel = 0, chlngt = 0;

double xdif, ydif;

if (spatial && spacetime_option != 5) {
   getboundaries_();
}

/* Do requested surface calculation.
   Note: spacetime_option = 0 or 1 is handled in report_(). */

if (spacetime_option == 2) {

   // Display ID conditional marginal probabilities.

   Surfcalcs.display_marg_();

} else if (spacetime_option == 3 || spacetime_option == 4) {

   // Overlay a grid and boundaries or convert a label-grid file.

   Surfcalcs.grid_();

} else if (spacetime_option == 5) {

   // Overlay two surfaces.

   Surfcalcs.overlay_();

} else if (spacetime_option == 6) {

   /* Estimate LOMAP/GLOMAP variables parameters under the conditioning
      values given in the "conditions" command.  If this is a spatial-only
      LOMAP/GLOMAP variable, estimate parameters for each unique Time
      value between tmin and tmax (see "estpars_"). */

   krgset_(0);
   Surfcalcs.estpars_(0., 0., 0.);

} else if (spacetime_option == 7) {

   // Cross-validation computations.  First, initialize things.

   icrval = 1;
   krgset_(0);
   Pxp pxpobj = new Pxp();
 
   if (nmstmixcntr == 0) {

      if (fitglobalparameters) {

         /* Estimate LOMAP's global parameters and use last function
	    evaluation's output for the cross-validation results, see
	    "estglbl_." */

         Estglbl.estglbl_();

      } else {
         Surfcalcs.crossval_(true, 0, 1);
      }

   } else {

      // Compute cross-validation predictions.

      if (spatial && !temporal && parm_mvar == 2 && nmstmixcntr > 1) {
	 nmskip = 8;
      
      } else {
	 nmskip = 1;
      }
      Surfcalcs.crossval_(true, 0, nmskip);
   }

} else if (spacetime_option == 8) {

   // Compute a surface.

   krgset_(0);
   Pxp pxpobj = new Pxp();
   Surfcalcs.surface_();

} else if (spacetime_option == 9) {

   /* Compute the volume under a surface and associated Monte Carlo
      confidence interval (C.I.). */

   krgset_(0);
   Mchtsts.mcvolci_(spacetime_nmmc);
 
} else if (spacetime_option == 10) {

   // Plot a surface.

   fleopen_(3, "out.dig", 'w');
   Pltsurf.pltsurf_(1, spacetime_surffle[0], 3, spacetime_psfle);

} else if (spacetime_option == 11) {

   // Label regions.

   fleopen_(3, "out.dig", 'w');
   Pltsurf.pltsurf_(0, spacetime_surffle[0], 3, spacetime_psfle);

} else if (spacetime_option == 13) {

   /* Optimally delete "ndel" sites from a monitoring network.  First,
      zero out the deletion frequency counter. */

   for (i = 0; i < nmsites[0]; ++i) {
      deldst[i] = 0;
   }
   
   /* n is the length of the vector, ndel is the number of zeroes.
      "chlngt" is the number of solutions reachable in one "move"
      step. */

   ndel = 5;
   for (i = 0; i < ndel; ++i) {
      siteonoff[i] = 0;
   }
   for (i = ndel; i < nmsites[0]; ++i) {
      siteonoff[i] = 1;
   }
   chlngt = ndel * (nmsites[0] - ndel);

   Surfcalcs.weight[0] = .5;
   Surfcalcs.weight[1] = .5;

   Simanel.simanel_(nmsites[0], chlngt, siteonoff, 0., 1.e-5, 1);

   // Print the best and worst network redesign solution.

   fprintf_(1, "Note: fcn1 and fcn2 are the relative change" +
      " from the 'Before' values.\n" +
      "\n*********** Sites to Delete ************\n" +
      "X coordinate         Y coordinate\n" +
      "Interpretation: Deleting these sites gives the minimum\n" +
      "score of: " + Simanel.smin[0] + " with function values fcn1= " +
      Simanel.smin[1] + " fcn2= " + Simanel.smin[2] +
      "Component 1= " + (Surfcalcs.before[0] * (Simanel.smin[0] + 1.)) +
      " Component 2= " + (Surfcalcs.before[1] * (Simanel.smin[1] + 1.)));

   fprintf_(1, "***** Most Important Sites to Retain *****" +
      "X coordinate        Y coordinate" +
      "Interpretation: Deleting these sites gives the maximum\n" +
      "score of: " + Simanel.smax[0] + " with function values fcn1= " +
      Simanel.smax[1] + " fcn2= " + Simanel.smax[2] +
      "Component 1= " + (Surfcalcs.before[0] * (Simanel.smax[0] + 1.)) +
      " Component 2= " + (Surfcalcs.before[1] * (Simanel.smax[1] + 1.)));

   // Print the deletion counter vector.

   fprintf_(1, " Deletion Counter" +
      " Subregion Site ID    Frequency of Deletion");

   for (i = 0; i < nmsites[0]; ++i) {
      fprintf_(1, (i + 1) + "     " + deldst[i]);
   }
}
}

// ---------------------------------------------------------------------

static void getboundaries_() {

// Reads the boundaries file and initializes things.

int i, j, k, l;

double mindif, xdif, ydif, avex, avey, dist;

spacetime_xmin = 1.e20;
spacetime_xmax = -1.e20;
spacetime_ymin = 1.e20;
spacetime_ymax = -1.e20;

/* Read boundary or boundaries and detect both the global extremes
   (spacetime_xmin, spacetime_xmax, spacetime_ymin, spacetime_ymax)
   and the extremes for individual regions. */

fleopen_(3, spacetime_bdrysfle, 'r');
fgetline_(3);
fgetline_(3);

j = 0;
for (;;) {
   bdry_xmin[j] = 1.e20;
   bdry_xmax[j] = -1.e20;
   bdry_ymin[j] = 1.e20;
   bdry_ymax[j] = -1.e20;
   bdry_meanrad[j] = 0.;
   bdry_minrad[j] = 1.e20;
   bdry_maxrad[j] = -1.e20;
   bdry_predmin[j] = 1.e20;
   bdry_predmax[j] = -1.e20;
   bdry_kvarmin[j] = 1.e20;
   bdry_kvarmax[j] = -1.e20;
   bdry_cvmin[j] = 1.e20;
   bdry_cvmax[j] = -1.e20;
   bdry_cimin[j] = 1.e20;
   bdry_cimax[j] = -1.e20;
   bdry_nugmin[j] = 1.e20;
   bdry_nugmax[j] = -1.e20;
   bdry_sillmin[j] = 1.e20;
   bdry_sillmax[j] = -1.e20;

   // Read number of boundary points, boundary name, and country number.

   bdry_nmbdpts[j] = fgetint_(3);
   if (bdry_nmbdpts[j] > MAXNMBPT) {
      iderr_("getboundaries: too many boundary points, MAXNMBPT= " +
	 MAXNMBPT);
   }
   bdry_reglabel[j] = fgetstrng_(3);
   bdry_countrynm[j] = fgetint_(3);

   /*
   printf_("getboundaries: j= " + j + " region= " + bdry_reglabel[j] +
      " nmbdpts= " + bdry_nmbdpts[j]);
   */

   for (i = 0; i < bdry_nmbdpts[j]; ++i) {
      bdry_xbdry[j][i] = fgetdble_(3);
      bdry_ybdry[j][i] = fgetdble_(3);

      if (spacetime_xmin > bdry_xbdry[j][i]) {
         spacetime_xmin = bdry_xbdry[j][i];
      }
      if (spacetime_xmax < bdry_xbdry[j][i]) {
         spacetime_xmax = bdry_xbdry[j][i];
      }
      if (spacetime_ymin > bdry_ybdry[j][i]) {
         spacetime_ymin = bdry_ybdry[j][i];
      }
      if (spacetime_ymax < bdry_ybdry[j][i]) {
         spacetime_ymax = bdry_ybdry[j][i];
      }
      if (bdry_xmin[j] > bdry_xbdry[j][i]) bdry_xmin[j] = bdry_xbdry[j][i];
      if (bdry_xmax[j] < bdry_xbdry[j][i]) bdry_xmax[j] = bdry_xbdry[j][i];
      if (bdry_ymin[j] > bdry_ybdry[j][i]) bdry_ymin[j] = bdry_ybdry[j][i];
      if (bdry_ymax[j] < bdry_ybdry[j][i]) bdry_ymax[j] = bdry_ybdry[j][i];
   }
      
   // Increment number-of-boundaries counter.

   ++j;

   // If at EOF, break.

   if (checkeof_(3)) {
      bdry_nmbdrys = j;
      break;
   }

   // Check number-of-boundaries counter before loading next boundary.

   if (j >= MAXNMBD) {
      iderr_("getboundaries: too many boundaries, MAXNMBD= " + MAXNMBD);
   }
}
fclose_(3, 'r');

// Determine plotting transformation constants.

xdif = spacetime_xmax - spacetime_xmin;
ydif = spacetime_ymax - spacetime_ymin;
mindif = .002 * Math.max(xdif, ydif);

xscale = xdif;
if (ydif > xdif) xscale = ydif;
xscale = .75 * (1. / xscale);
yscale = xscale;
xshift = .05;
yshift = .05;

/* "Snap" boundary points together that are (a) each from a different
   boundary, (b) are very close to each other, but (c) are not at the
   the same location. */

for (i = 0; i < bdry_nmbdrys; ++i) {
   for (j = 0; j < i; ++j) {
      for (k = 0; k < bdry_nmbdpts[i]; ++k) {
	 for (l = 0; l < bdry_nmbdpts[j]; ++l) {
            xdif = (bdry_xbdry[i][k] - bdry_xbdry[j][l]);
            ydif = (bdry_ybdry[i][k] - bdry_ybdry[j][l]);
            dist = xdif * xdif + ydif * ydif;
	    dist = Math.sqrt(dist);

	    if (dist < mindif) {
	       /*
	       avex = .5 * (bdry_xbdry[i][k] + bdry_xbdry[j][l]);
	       avey = .5 * (bdry_ybdry[i][k] + bdry_ybdry[j][l]);
	       */
	       avex = bdry_xbdry[i][k];
	       avey = bdry_ybdry[i][k];
	       bdry_xbdry[i][k] = avex;
	       bdry_ybdry[i][k] = avey;
	       bdry_xbdry[j][l] = avex;
	       bdry_ybdry[j][l] = avey;
	    }
	 }
      }
   }
}
}

// ---------------------------------------------------------------------

static double bdry_(int nmbdpts, double xbdry[], double ybdry[],
   double xcord, double ycord) {

/* Checks to determine if the point (xcord,ycord) is inside the closed
   boundary defined by xbdry and ybdry.  The boundary point list can
   be either clockwise or counter-clockwise. Returns smallest distance
   to the boundary -- if outside the boundary, this distance is negative.
*/
 
int i, j, stp = 1;

double xdif, ydif, ratio, xtest, ytest, difx, dify, lftdst = -1.,
   rtdst = -1., bwdst = -1., updst = -1., dist, dstmin = 0., xval = 0.,
   xi = 0., xmstp = 0., xbdryval = 0., ybdryval = 0.;

if (xislongitude) {
   xval = -xcord;

} else {
   xval = xcord;
}

// Find the closest pair of boundary points that are to the left, to
// the right, below, and above the point.  First, check counter-clockwise.

for (i = stp; i <= nmbdpts - 1; ++i) {

   if (xislongitude) {
      xmstp = -xbdry[i - stp];
      xi = -xbdry[i];

   } else {
      xmstp = xbdry[i - stp];
      xi = xbdry[i];
   }

   // Find closest pair of boundary points that are to the left of the
   // point.

   ratio = Math.abs((ycord - ybdry[i]) / (ybdry[i - stp] - ybdry[i]));
   xbdryval = xi * (1. - ratio) + xmstp * ratio;

   ratio = Math.abs((xval - xi) / (xmstp - xi));
   ybdryval = ybdry[i] * (1. - ratio) + ybdry[i - stp] * ratio;

   if (ycord >= ybdry[i] && ycord <= ybdry[i - stp] && xbdryval <= xval) {
      lftdst = xval - xbdryval;
   }

   // Find closest pair of boundary points that are to the right of the
   // point.

   if (ycord <= ybdry[i] && ycord >= ybdry[i - stp] && xval <= xbdryval) {
      rtdst = xbdryval - xval;
   }

   // Find closest pair of boundary points that are below the
   // point.

   if (xval <= xi && xval >= xmstp && ybdryval <= ycord) {
      bwdst = ycord - ybdryval;
   }

   // Find closest pair of boundary points that are above the
   // point.

   if (xval >= xi && xval <= xmstp && ycord <= ybdryval) {
      updst = ybdryval - ycord;
   }
}

// Compute smallest distance to a boundary point.

for (i = 1; i <= nmbdpts - 1; ++i) {
   difx = xcord - xbdry[i - 1];
   dify = ycord - ybdry[i - 1];
   dist = Math.sqrt(difx * difx + dify * dify);
   if (i == 1 || dist < dstmin) {
      dstmin = dist;
   }
}

// If point is in region, return dstmin > 0.  Otherwise, check clockwise.

if (lftdst >= 0. && rtdst >= 0. && bwdst >= 0. && updst >= 0.) {
   return dstmin;
}

// Clockwise direction.

lftdst = -1.;
rtdst = -1.;
bwdst = -1.;
updst = -1.;
for (i = stp; i <= nmbdpts - 1; ++i) {

   if (xislongitude) {
      xmstp = -xbdry[i - stp];
      xi = -xbdry[i];

   } else {
      xmstp = xbdry[i - stp];
      xi = xbdry[i];
   }

   ratio = Math.abs((ycord - ybdry[i]) / (ybdry[i - stp] - ybdry[i]));
   xbdryval = xi * (1. - ratio) + xmstp * ratio;

   ratio = Math.abs((xval - xi) / (xmstp - xi));
   ybdryval = ybdry[i] * (1. - ratio) + ybdry[i - stp] * ratio;

   /* Find closest pair of boundary points that are to the left of the
      point. */

   if (ycord <= ybdry[i] && ycord >= ybdry[i - stp] && xbdryval <= xval) {
      lftdst = xval - xbdryval;
   }

   /* Find closest pair of boundary points that are to the right of the
      point. */

   if (ycord >= ybdry[i] && ycord <= ybdry[i - stp] && xval <= xbdryval) {
      rtdst = xbdryval - xval;
   }

   /* Find closest pair of boundary points that are below the
      point. */

   if (xval >= xi && xval <= xmstp && ybdryval <= ycord) {
      bwdst = ycord - ybdryval;
   }

   /* Find closest pair of boundary points that are above the
      point. */

   if (xval <= xi && xval >= xmstp && ycord <= ybdryval) {
      updst = ybdryval - ycord;
   }
}

// Compute smallest distance to a boundary point.

for (i = 1; i <= nmbdpts - 1; ++i) {
   difx = xcord - xbdry[i - 1];
   dify = ycord - ybdry[i - 1];
   dist = Math.sqrt(difx * difx + dify * dify);
   if (i == 1) {
      dstmin = dist;
   }
   if (dist < dstmin) {
      dstmin = dist;
   }
}

/* If point is in region, return dstmin > 0.  Otherwise, return
   dstmin = -dstmin. */
 
if (lftdst >= 0. && rtdst >= 0. && bwdst >= 0. && updst >= 0.) {
   return dstmin;

} else {
   return -dstmin;
}
}

// ---------------------------------------------------------------------

static void krgset_(int option) {

/* Sets up kriging prediction.  This collection of programs have
   evolved in the distant past from the program in
   Carr, J. R. et al.  (1985), "Cokriging - A Computer
   Program," Computers and Geosciences, 11(2).  The program performs
   various forms of kriging and sampling network design. 
 
   Network optimization flag, "option" values are
   0: regular estimation mode
   1: initialization of optimization mode, regular grid computation of
      variogram pattern
   2: regular optimization function call evaluation, no printing
   3: Using data already stored in vardat, find relative error at
      (xloc, yloc) and do no printing. */

int i, j, start, finish;
double dstmin;
double a[] = new double[OPTSIZE];
double g[] = new double[OPTSIZE];
double h[] = new double[OPTSIZE];

// Read constants and data.

input_(); 

if (option == 1) { 
   if (icrval != 0) iderr_("icrval must be 0 for network optimization.");
   if (spacetime_grdtyp != 1) iderr_("grdtyp must be 1 for optimization."); 
}
for (i = 0; i < parm_mvar; ++i) varmod_anis[i] *= .01745329;

// Determine number of sites to include in a cylinder.

for (i = 0; i < parm_mvar; ++i) {
   if (spatial) {
      ndmin[i] = (int) (datfrac[i] * ((double) nmsites[i]));

   } else {
      ndmin[i] = nmobs[idnmbrm1][lomapnms[i] - 1];
   }
   if (option < 2) {
      fprintf_(1, "Variable= " + lomapnms[i] +
         " count= " + nmobs[idnmbrm1][lomapnms[i] - 1] +
         " Number of within-region sites= " + nmsites[i] +
         "\ndatfrac= " + datfrac[i]);
      if (spatial) {
	 fprintf_(1, " Number of sites within a cylinder= " + ndmin[i]);
      }
   }
}

// If addsts > 0, nmobs[idnmbrm1][lomapnms[0] - 1] is increased by addsts.

if (option == 1 && addsts > 0) {
   nmobs[idnmbrm1][lomapnms[0] - 1] += addsts;
}

// Initialize variogram modeling.

Vargrm.vargrm_(1, true, 0., 0., 0., a, g, h);

// Open intermediate file of kriging estimates.

if (option == 0) {
   fleopen_(5, "kest.tmp", 'w');
}

// Open parameter estimates file.

fleopen_(6, estfle, 'w');
}

// -----------------------------------------------------------------------

static void input_() {
 
// Reads the control and data files.
 
String prdlocf;

String names[] = new String[TNMNDS];

int i, j, k, intval, vnmbr, retnm, prntnm;

double s1, s2, rn, xdif, ydif, dist, xdum, ydum, rnmobs, val;

double mean[] = new double[NUMVAR];
double mdat[] = new double[DATSZE];
double moments[] = new double[4];

// Check validity of parameter values.

if (icrval == 0 && spacetime_grdtyp == 2 &&
   2 * (spacetime_nmrows / 2) == spacetime_nmrows) {
   iderr_("must have odd number of rows for hexagon grid.");
}

for (i = 0; i < parm_mvar; ++i) {

   /* For each variable, get LOMAP global parameters.  For a
      spatio-temporal model, these are: trnsfrm, kmax, kmaxt, itrend, and
      the spatial and temporal cylinder sizes, respectively.  For a
      spatial-only model, kmaxt and the temporal cylinder size parameters
      are omitted.  For a GLOMAP variable, there is an additional
      parameter: the number of kernel centers. */

   // Detect a temporal node.

   if (varinfo_temporal[idnmbrm1][lomapnms[i] - 1]) {
      temporal = true;
   }

   /* Set transformation switch ("intval" is simply a dummy integer
      variable to allow easy input of the boolean variable, "trnsfrm." */

   intval = (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1]
				 [0][0][0][0][0][0][0][0];

   if (intval == 0) {
      trnsfrm = false;
   
   } else if (intval == 1) {
      trnsfrm = true;
   
   } else {
      iderr_("invalid trnsfrm parameter");
   }

   kmax = (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][1]
	                       [0][0][0][0][0][0][0];
   j = 2;

   if (temporal) {
      kmaxt = (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
	                           [0][0][0][0][0][0][0];
      ++j;

   } else {
      kmaxt = 0;
   }

   varmod_model[i] = 
             (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
				  [0][0][0][0][0][0][0];
   ++j;

   if (temporal) {
      dum =  (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
				  [0][0][0][0][0][0][0];
      if (dum == 1) {
         lngmem = true;
      }
      ++j;
   }

   itrend = (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
				 [0][0][0][0][0][0][0];
   ++j;

   quantvarmodel = (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
				        [0][0][0][0][0][0][0];
   ++j;

   datfrac[i] = Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
	                       [0][0][0][0][0][0][0];
   ++j;

   if (temporal) {
    
      tlngth[i] = Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
			         [0][0][0][0][0][0][0];
      ++j;

   } else {
      tlngth[i] = 0.;
   }

   if (varinfo_dist[idnmbrm1][lomapnms[i] - 1].equals("GLOMAP")) {
      nmstmixcntr =
	 (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
			      [0][0][0][0][0][0][0];
      ++j;
      covnonstatmdl =
	 (int) Readnet.condprb[idnmbrm1][lomapnms[i] - 1][j]
			      [0][0][0][0][0][0][0];
      ++j;
   }

   // Check for valid number of temporal lags

   if (2 * kmaxt + 1 > LGDIM) {
      iderr_("Surf.input: kmaxt= " + kmaxt + " and 2kmaxt+1 > LGDIM");
   }

   // Check for valid data fraction.

   if (datfrac[i] <= 0. || datfrac[i] > 1.) {
      iderr_("Surf.input: datfrac(" + (i + 1) + ")= " + datfrac[i]);
   }

   // Kluge to get a seasonality model for the sulfate s-t example

   if (temporal && spatial &&
       nodelbls[idnmbrm1][lomapnms[i] - 1][0].equals("Wet_SO4_Deposition")) {
      seasclc = true;
   }

   // Read any quantitative and/or qualitative predictors for this variable.

   nmquantvar = 0;
   nmqualvar = 0;
   for (j = 1; j <= nodenghs[idnmbrm1][lomapnms[i] - 1][1]; ++j) {
      prntnm = nodenghs[idnmbrm1][lomapnms[i] - 1][j + 1];
      if (!nodelbls[idnmbrm1][prntnm - 1][0].equals("Xcoord") &&
	  !nodelbls[idnmbrm1][prntnm - 1][0].equals("Ycoord") &&
	  !nodelbls[idnmbrm1][prntnm - 1][0].equals("Zcoord") &&
	  !nodelbls[idnmbrm1][prntnm - 1][0].equals("Time")) {

         if (nodenghs[idnmbrm1][prntnm - 1][0] == 1) {
	    quantvarnms[i][nmquantvar] = prntnm;
            ++nmquantvar;

         } else {
	    nmquallvl[nmqualvar] = nodenghs[idnmbrm1][prntnm - 1][0];
	    qualvarnms[i][nmqualvar] = prntnm;
	    ++nmqualvar;
	 }
      }
   }
}

// Variogram data entry.
 
varmod_nugget[0][0] = 1.;
varmod_sill[0][0] = 1.;
varmod_range[0][0][0] = 1.;
varmod_anis[0] = 1.;
varmod_ratio[0] = 1.;

/* Create a map between cross-covariogram parameter arrays and LOMAP/GLOMAP
   numbers. */

k = parm_mvar + 1;
for (i = 0; i < parm_mvar; ++i) {
   for (j = 0; j < i; ++j) {
      printf_("Surf.input: i= " + i + " j= " + j + " k= " + k);
      crossmap[i][j] = k;
      crossmap[j][i] = k;
      ++k;
   }
}

/* Switch to fit a nonlinear model and the number of temporal slices
   in the spatio-temporal grid. */

nonlin = false;
spacetime_ntimes = 1;

// If icrval is 2, read prediction locations.
 
prdlocf = "none";
if (icrval == 2) {
   fleopen_(5, prdlocf, 'r');
   i = 0;
   while(checkeof_(5) != true) {
      prdloc[i][0] = fgetdble_(5);
      prdloc[i][1] = fgetdble_(5);
      prdloc[i][2] = fgetdble_(5);
      ++i;
   }
   spacetime_nmrows = i;
   fclose_(5, 'r');
}

// Read data.

retnm = Getdata.getdata_(datafle, names);
if (retnm != parm_mvar) {
   iderr_("surf: retnm= " + retnm + " parm_mvar= " + parm_mvar +
      " getdata read different number of variables");
}
if (nmsites[0] == 1) {
   spatial = false;
}

// Set tmin and tmax.

spacetime_tmin = spacetime_begintime;
spacetime_tmax = spacetime_endtime;

if (simdat) {

   /* For development purposes, simulate a data set from a known
      distribution. */

   Mchtsts.simdat_();
}

fprintf_(1, "\n             ** Input Data **\n");
fprintf_(1, "  X    Y  Time  Variable  Value");
for (i = 0; i < nmecoobsttl; ++i) {
   fprintf_(1, " " + dat2_x[i] + "  " + dat2_y[i] + "  " + dat2_t[i] +
      "      " + dat2_vrble[1][i] + "      " + dat2_dat[i]);
}

// Find the data tmin, tmax.

for (i = 0; i < nmecoobsttl; ++i) {
   if (dat2_t[i] < dattmin) dattmin = dat2_t[i];
   if (dattmax < dat2_t[i]) dattmax = dat2_t[i];
}

/* Calculate global means, variances, and total sum-of-squares for each
   variable. */

for (i = 0; i < parm_mvar; ++i) {
   glblsmplvr[i] = 0.;
}

for (i = 0; i < nmecoobsttl; ++i) {
   vnmbr = dat2_vrble[1][i];
   glblmean[vnmbr - 1] += dat2_dat[i];
}

for (i = 0; i < parm_mvar; ++i) {
   rnmobs = nmobs[idnmbrm1][lomapnms[i] - 1];
   glblmean[i] /= rnmobs;
}

for (i = 0; i < nmecoobsttl; ++i) {
   vnmbr = dat2_vrble[1][i];
   val = dat2_dat[i] - glblmean[vnmbr - 1];
   glblsmplvr[vnmbr - 1] += val * val;
}

fprintf_(1, "\n Note: Global means and variances are in orginal scale.");
fprintf_(1, "\n  Variable    n   Sample Mean     Sample Variance");
for (i = 0; i < parm_mvar; ++i) {
   rnmobs = nmobs[idnmbrm1][lomapnms[i] - 1];
   glblsmplvr[i] /= (rnmobs - 1.);
   fprintf_(1, " " + nodelbls[idnmbrm1][lomapnms[i] - 1][0] + "      " +
      nmobs[idnmbrm1][lomapnms[i] - 1] + "    " +
      fdble_(glblmean[i], 9, 5) + "      " +
      fdble_(glblsmplvr[i], 9, 5));

   k = 0;
   for (j = 0; j < nmecoobsttl; ++j) {
      if (dat2_vrble[1][j] == i + 1) {
         mdat[k] = dat2_dat[j];
         ++k;
      }
   }
   fprintf_(1, "\n   Real line scale moments:");
   Summry.moments_(true, nmobs[idnmbrm1][lomapnms[i] - 1], mdat, moments);
   
   // Store these real-line moments.

   for (j = 0; j < 4; ++j) {
      realmmts[i][j] = moments[j];
   }
}
fprintf_(1,"\nTotal number of observations= " + nmecoobsttl);

/* Find smallest and largest spatial distances between any two
   observations irregardless of the variable number.  Use the smallest
   spatial distance for "varmod_epsln" and the largest for the
   semivariogram spatial range limit. */

if (spatial) {
   varmod_epsln = 1.e30;
   varmod_rngelim = 0.;
   for (i = 0; i < nmecoobsttl; ++i) {
      for (j = 0; j < i; ++j) {
         if (dat2_t[i] == dat2_t[j] &&
	     dat2_vrble[1][i] == dat2_vrble[1][j]) {
            xdif = dat2_x[i] - dat2_x[j];
            ydif = dat2_y[i] - dat2_y[j];
            dist = Math.sqrt(xdif * xdif + ydif * ydif);
            if (dist < varmod_epsln) {
	       varmod_epsln = dist;
	    }
            if (dist > varmod_rngelim) {
	       varmod_rngelim = dist;
	    }
	 }
      }
   }

} else if (!spatial && temporal) {
   varmod_epsln = 1.e-3;
   varmod_rngelim = 1.e-3;
}
fprintf_(1, "\nSmallest distance between two spatial sampling sites= " +
   varmod_epsln + "\nSpatial range upper boundary= " + varmod_rngelim);

//  Echo input options.
 
/*
printf_("input: !!!!!!!!!!!!!!!!! forcing parm_mvar to 1 !!!!!!!!!!!!!!");
parm_mvar = 1;
*/

fprintf_(1, 
"\n---------------- KRIGING ESTIMATION OUTPUT --------------\n");
if (parm_mvar > 1) fprintf_(1, "Covariable(s) will be used.\n");
fprintf_(1, "itrend = " + itrend);
if (itrend == 0) {
   fprintf_(1, "Ordinary Kriging\n");

} else if (itrend == 1 || itrend == 2) {
   fprintf_(1, "Universal Kriging, order of trend= " + itrend);

} else if (itrend == 3) {
   fprintf_(1, "Lognormal Kriging");

} else if (itrend == 4 || itrend == 5 || itrend == 6) {
   fprintf_(1, "Regression, Residual Kriging");
   if (temporal) {
      fprintf_(1, "Order of spatial trend polynomial: " + (itrend - 4));
   }

} else if (itrend == 10) {
   fprintf_(1, "Fourier Series Partial Sum Model");

} else if (itrend == 11) {
   fprintf_(1, "Venkatram's Compartmental Model");
}

// Inform which system is being used.

if (nmstmixcntr > 0) {
   fprintf_(1, "Global Model Estimation");

} else {
   Estimate.local = true;
   fprintf_(1, "Local Model (Moving Cylinder) Estimation");
   if (trnsfrm) {

      // Initialize transformation parameters.

      trnsfrm_tau1[0] = 1.;
      trnsfrm_tau2[0] = 1.;
      trnsfrm_invtau1[0] = 1.;
      trnsfrm_invtau2[0] = 1.;

      trnsfrm_tau1[1] = 1.;
      trnsfrm_tau2[1] = 1.;
      trnsfrm_invtau1[1] = 1.;
      trnsfrm_invtau2[1] = 1.;
   }
}
}

// ----------------------------------------------------------------------

static void exactsg_(double mtrx[][], int i, String routne) {

// Checks mtrx for exact singularity.

int j, cvstrct, stnmi, stnmj;
double difx, dify, dift, dcos, dsin, dumx, dumy, dist;

for (j=0; j < i; ++j) {
   if (mtrx[i][j] == mtrx[i][i]) {
      printf_("mtrx(" + i + "," + i + ")= " + mtrx[i][i]);
      printf_("mtrx(" + i + "," + j + ")= " + mtrx[i][j]);

      printf_("i= " + i + " x= " + vardat_x[i] + " y= " + vardat_y[i] +
	 " t= " + vardat_t[i] + " vrble= " + vardat_vrble[i]);

      printf_("j= " + i + " x= " + vardat_x[j] + " y= " + vardat_y[j] +
	 " t= " + vardat_t[j] + " vrble= " + vardat_vrble[j]);

      // Find covariance structure.

      stnmi = idtostnm[vardat_vrble[i] - 1];
      stnmj = idtostnm[vardat_vrble[j] - 1];
      if (stnmi == stnmj) {
         cvstrct = stnmi;
      
      } else {
         cvstrct = crossmap[stnmi - 1][stnmj - 1];
      }

      // Compute distance.

      difx = vardat_x[i] - vardat_x[j];
      dify = vardat_y[i] - vardat_y[j];
      dift = Math.abs(vardat_t[i] - vardat_t[j]);
      dcos = Math.cos(varmod_anis[0]);
      dsin = Math.sin(varmod_anis[0]);
      dumx = difx * dcos + dify *dsin;
      dumy = varmod_ratio[0] * (dify * dcos - difx * dsin);
      dist = Math.sqrt(dumx * dumx + dumy * dumy);

      // Print covariance structure parameters.

      Covmodl.covprt_(1);

      iderr_("Exact singularity in routine " + routne);
   }
}
}
}
