public class Surfcalcs extends Surf {

static int values[] = new int[TNMVALS];
static int nmregsites[] = new int[MAXNMBD];
static int inarry[] = new int[SIMASZE];
static int delarry[] = new int[SIMASZE];

static double objfcn[] = new double[2];
static double weight[] = new double[2];
static double before[] = new double[2];
static double dscrtdst[][] = new double[MAXNMBD][TNMVALS];

// --------------------------------------------------------------------

public static void display_marg_() {

/* Surface display of an ID marginal distribution.  For a discrete node, the
   probability of the first value is plotted.  For a quantitative node, the
   mean of the node is plotted.
   grdtyp = 1: rectangular grid
   grdtyp = 2: hexagonal grid. */

int i, j, k, outnode = 0;

double xdif, ydif, val, xcord, ycord, tmecord;

double prbval1[] = new double[TNMVALS];

// Find output node number.

for (i = 1; i <= nmnds; ++i) {
   if (varinfo_eval[idnmbrm1][i - 1]) {
      outnode = i;
      break;
   }
}

/* First, compute probability or mean of the requested node over all
   values of the spatial conditioning node (the "map" node). */

for (i = 1; i <= nodenghs[idnmbrm1][map - 1][0]; ++i) {

   /* map node is assumed to be the first conditioning variable (this
      ordering is established by the "conditions" statement in the .id
      file). */

   condvals[0] = i;
   Beliefs.beliefs_(1, 0.);

   // Use the last time point.

   if (!Beliefs.loadconsdst) {
      prbval1[i - 1] =
         Beliefs.beliefh[0][Beliefs.nmoutt - 1][outnode - 1][0];

   } else {
      prbval1[i - 1] =
         Beliefs.beliefc[0][Beliefs.nmoutt - 1][outnode - 1][0];
   }
   printf_("display_marg: i= " + i + " prbval1= " + prbval1[i-1]);
}

/* Set surface extremes, and the number of rows and columns.  Also,
   compute coordinate increments. */

spacetime_estmin = 0.;
spacetime_estmax = 1.;
spacetime_nmrows = 50;
spacetime_nmcols = 50;
xdif = (spacetime_xmax - spacetime_xmin) / (double) (spacetime_nmcols - 1);
ydif = (spacetime_ymax - spacetime_ymin) / (double) (spacetime_nmrows - 1);

// Open the grid file and write header information.

fleopen_(2, "prob.sgd", 'w');
fprintf_(2, spacetime_grdtyp + " " + spacetime_nmrows + " " +
   spacetime_nmcols + " " + spacetime_xmin + " " + spacetime_xmax + " " +
   spacetime_ymin + " " + spacetime_ymax + " " + spacetime_estmin + " " +
   spacetime_estmax);

/* For each point in a rectangular grid, set each point to the region's
   first-value probability or mean. */

ycord = spacetime_ymin;
for (i = 0; i < spacetime_nmrows; ++i) {
   xcord = spacetime_xmin;
   for (j = 0; j < spacetime_nmcols; ++j) {
      val = 0.;

      // Find boundary membership, if any.

      iblank = 1;
      for (k = 0; k < nodenghs[idnmbrm1][map - 1][0]; ++k) {
	 if (bdry_(bdry_nmbdpts[k], bdry_xbdry[k], bdry_ybdry[k],
	    xcord, ycord) > 0.) {
	    val = prbval1[k];
	    iblank = 0;
	    break;
	 }
      }
      
      fprintf_(2, fdble_(xcord, 5, 3) + " " + fdble_(ycord, 5, 3) +
	 " " + val + " " + iblank);
      xcord += xdif;
   }
   ycord += ydif;
}
fclose_(2, 'w');

// Plot this surface.  First, open device-independent output graphics file.

fleopen_(3, "out.dig", 'w');
Pltsurf.pltsurf_(1, "prob.sgd", 3, "marg.ps");
}

// --------------------------------------------------------------------

public static void grid_() {

// Overlay a grid and boundaries or convert a label-grid file.

xscale *= 12.5 / 10.;
yscale *= 16.8 / 13.5;

// Open device-independent output graphics file.

fleopen_(3, "out.dig", 'w');

/* Depending on "spacetime_option," the method "pltgrid_" will either
   create a grid or convert a label-grid file to a .sgd file. */

Pltsleg.pltgrid_(3);

if (spacetime_option == 3) {
   fclose_(3, 'w');

   // Create the PostScript plot file.

   Pltpost.pltpost_("grid.ps", 1.4);

} else if (spacetime_option == 4) {
   Pltsurf.pltsurf_(1, spacetime_surffle[0], 3, spacetime_psfle);
}
}

// ---------------------------------------------------------------------

public static void estpars_(double xcord, double ycord, double tmecord) {

/* Estimates the LOMAP/GLOMAP model.  If local = false, estimates one set
   of parameters.  Otherwise, estimates a set of parameters at each grid
   point, storing these sets in "grdvar." */

int i;

icrval = 0;
jtime = 1;
spacetime_predoption = 2;

/* If the LOMAP/GLOMAP variables are spatial-only, compute separate parameter
   estimates at each time in the sample.  Otherwise, compute a single
   set of parameter estimates using all data. */

if (!temporal) {
   for (i = 0; i < nmdattimes; ++i) {
      if (spacetime_tmin <= dattimes[i] && dattimes[i] <= spacetime_tmax) {
         tmecord = dattimes[i];
         Predict.modelisfit = false;
         Predict.predict_(0, -1, 1, 1, xcord, ycord, tmecord);
      }
   }

} else if (temporal) {
   tmecord = .5 * (spacetime_tmax + spacetime_tmin);
   Predict.predict_(0, -1, 1, 1, xcord, ycord, tmecord);
}

// Close parameter estimates file.

fclose_(6, 'w');
}

// ---------------------------------------------------------------------

public static void crossval_(boolean wflag, int option, int nmskip) {

// Performs cross-validation.

int i, j, k = 0, nmcrval = 0, counter = 0;
int ivals[] = new int[DATSZE];
double xcord, ycord, tmecord;

/* Set cross-validation indicator to "on."  Note, "spacetime_begintime"
   and "spacetime_endtime" are set in getmodl. */

icrval = 1;

/* Set number of cross-validation predictions: those observerations between
   "spacetim_begintime" and "spacetime_endtime." */

for (i = 0; i < nmecoobsttl; ++i) {
   if ((temporal && dat2_vrble[1][i] == 1 &&
        spacetime_begintime <= dat2_t[i] &&
        dat2_t[i] <= spacetime_endtime) ||
       !temporal) {
      ivals[nmcrval] = i;
      ++nmcrval;
   }
}
 
/* Set number of rows and columns and initialize number of predictions
   counter.  Note, no need to keep track of number of time points. */

spacetime_ntimes = 1;
spacetime_nmrows = Math.min(nmcrval, ROWLIM);
spacetime_nmcols = (nmcrval / ROWLIM) + 1;
if (spacetime_nmcols > COLLIM) {
   iderr_("nmcols= " + spacetime_nmcols + " > COLLIM");
}

if (wflag) {
   fprintf_(1, "\n----------------- Cross-validation -------------------\n");
   fprintf_(1," Number of potential cross-val predictions= " + nmcrval +
      " skip integer= " + nmskip);
   fprintf_(1, "Total number of cross-val. predictions to be computed= " +
      nmcrval / nmskip);
   fprintf_(1, "tmin= " + spacetime_tmin + " tmax= " + spacetime_tmax);
   fprintf_(1, "begintime= " + spacetime_begintime +
      " endtime= " + spacetime_endtime + " nmrows= " + spacetime_nmrows +
      " nmcols= " + spacetime_nmcols + "\n");
}

nmest = 0;
timeloop: for (jtime = 1; jtime <= spacetime_ntimes; ++jtime) {
   for (i = 1; i <= spacetime_nmrows; ++i) {
      for (j = 1; j <= spacetime_nmcols; ++j) {
         idatcr = ivals[k] + 1;
         ++k;
         ++counter;
         if (k > nmcrval) break timeloop;
	 iblank = 0;

         xcord = dat2_x[idatcr - 1];
         ycord = dat2_y[idatcr - 1];
         if (spacetime_begintime == spacetime_endtime) {
            tmecord = spacetime_endtime;
         
         } else {
            tmecord = dat2_t[idatcr - 1];
         }

         // Call prediction routine.

         // if (idatcr != 156) continue;
         // counter = 1;

         if (counter == nmskip) {
            Predict.predict_(0, option, i, j, xcord, ycord, tmecord);
            counter = 0;
         }
      }
   }
}

// Close intermediate file.

fclose_(5, 'w');

// Write statistics.

if (wflag) fprintf_(1, "Total number of cross-validation predictions: " +
   nmest);

// Write grid file.

if (spacetime_ntimes == 1) Srfgrd.srfgrd_(wflag);

if (wflag) {

   // Create PostScript normal plot.

   Pltnrm.pltnrm_();
}
}

// ---------------------------------------------------------------------

public static void surface_() {

// Computes a surface.

int i, j, jrow, jcol, rowhex = 0, colhex = 0, sbrgnnm = 1;

double ydim = 1., tdim = 1., xdif, ydif, tdif, hexside = 0., xbegin,
   ybegin, dstmin, xcord = 0., ycord = 0., tmecord = 0.;

/* Set cross-validation indicator to "off" and number of temporal layers
   to 1. */

icrval = 0;
spacetime_ntimes = 1;

/* Calculate xdif, ydif, tdif, xdim, ydim, tdim, and optionally, the
   hexagon side length. */
 
xdif = bdry_xmax[sbrgnnm - 1] - bdry_xmin[sbrgnnm - 1];
ydif = bdry_ymax[sbrgnnm - 1] - bdry_ymin[sbrgnnm - 1]; 
tdif = spacetime_tmax - spacetime_tmin;

if (spacetime_ntimes > 1) {
   tdim = tdif / ((double) (spacetime_ntimes - 1));

} else {
   tdim = 1.;
}

// Bounds checks on the number of rows.

if (spacetime_nmrows > ROWLIM) {
   iderr_("surface: nmrows= " + spacetime_nmrows + " > ROWLIM");
}
if (spacetime_nmrows <= 1) {
   iderr_("surface: nmrows <= 1");
}

// Compute y increment.

ydim = ydif / ((double) (spacetime_nmrows - 1));

// Compute the number of columns.

if (spacetime_grdtyp == 1) {

   // Rectangular grid.

   // spacetime_nmcols = spacetime_nmrows;

} else if (spacetime_grdtyp == 2) {

   // Hexagonal grid.  Also check that this is an even number.

   hexside = (2. * ydim) / 1.732050808;
   spacetime_nmcols = (int) (Math.floor(xdif / hexside) / 3) * 2 + 2;
   if (2 * (spacetime_nmcols / 2) < spacetime_nmcols) {
      --spacetime_nmcols;
   }
}

// Number of columns bounds checks.

if (spacetime_nmcols > COLLIM) {
   iderr_("surface: big spacetime_nmcols");
}

if (spacetime_nmcols <= 1) {
   iderr_("surface: spacetime_nmcols <= 1");
}

// Compute x increment.

spacetime_xdim = xdif / ((double) (spacetime_nmcols - 1));

// Define lower left corner as the beginning estimate point.

xbegin = bdry_xmin[sbrgnnm - 1];
ybegin = bdry_ymin[sbrgnnm - 1];

/* Allow the global model to be fitted by setting "frstfit" to true.
   After the first fit of the model, "stwrite_" will set "frstfit" to
   false. */

if (itrend >= 10) {
   frstfit = true;
}

// Write header file.

header_(icrval, ydim); 

/* Beginning of prediction loops.  First, the ``for'' loop for third
   dimension (time or depth). */

for (jtime = 1; jtime <= spacetime_ntimes; ++jtime) {

   // Set time coordinate.

   if (spacetime_ntimes == 1) tmecord = spacetime_endtime;
   else tmecord = spacetime_tmin + ((double) (jtime - 1)) * tdim;

   /* Master ``for'' loop for grid rows, start at bottom of grid:
      (row 1, column 1) is at the lower left hand corner (xmin, ymin). */

   for (jrow = 1; jrow <= spacetime_nmrows; ++jrow) {
      printf_("Beginning row " + jrow + "...");

      // Toggle row and column hexagon generating switches.

      if (rowhex == 1) {
         rowhex = 0;
         colhex = 1;

      } else if (rowhex == 0) {
         rowhex = 1;
         colhex = 0;
      } 

      // Master ``for'' loop for columns, start at left edge of grid.

      for (jcol = 1; jcol <= spacetime_nmcols; ++jcol) {

         // Find prediction location and associated covariate value.

         if (spacetime_grdtyp == 1) {

	    // Rectangular grid.

            xcord = xbegin + ((double) (jcol - 1)) * spacetime_xdim;

         } else if (spacetime_grdtyp == 2) {

	    // Hexagonal grid.

            if (colhex == 1) {
	       colhex = 0;
            
	    } else if (colhex == 0) {
	       colhex = 1;
            }

            if (jcol == 1) {
               xcord = xbegin + (((double) rowhex) * .5 * hexside);
            
            } else if (jcol > 1) {
               xcord += hexside * (1. + ((double) colhex));
            }
         }
         ycord = ybegin + ((double) (jrow - 1)) * ydim;
/*
            } else if (icrval == 2) {
	       if (idat > spacetime_nmrows) goto ENDKLP;
               xcord = prdloc[idat - 1][0];
               ycord = prdloc[idat - 1][1];
	       tmecord = prdloc[idat - 1][2];
            }
*/
         // Check boundary file region membership of prediction point.

         iblank = 0;
         dstmin = bdry_(bdry_nmbdpts[sbrgnnm - 1], bdry_xbdry[sbrgnnm - 1],
	       bdry_ybdry[sbrgnnm - 1], xcord, ycord); 
         if (dstmin < 0.) iblank = 1; 

         // Call prediction routine.

         Predict.predict_(0, 0, jrow, jcol, xcord, ycord, tmecord);
      }
   }
}

// Close intermediate file.

fclose_(5, 'w');

// Write statistics.

fprintf_(1, "Total number of predictions: " + nmest);

// Write grid file.

if (spacetime_ntimes == 1) Srfgrd.srfgrd_(true);
}

// ---------------------------------------------------------------------

public static double volume_(boolean first, int sbrgnnm) {

/* Computes predictions over a spatial grid and then computes the volume
   under this surface. */

boolean wflag = false;

int jcol, jrow;

double rjrow, rjcol, tdim = 1., dstmin, volume, xcord, ycord, tmecord;

// Bounds checks.

if (spacetime_nmrows > ROWLIM) {
   iderr_("nmrows>ROWLIM in volume_()");
}

if (spacetime_nmcols > COLLIM) {
   iderr_("nmcols>COLLIM in volume_()");
}

/* Set cross-validation indicator to "off" and initialize number of
   predictions counter. */

icrval = 0;
nmest = 0;
for (jtime = 1; jtime <= spacetime_ntimes; ++jtime) {

   // Set time coordinate.

   if (spacetime_ntimes == 1) tmecord = spacetime_endtime;
   else tmecord = spacetime_tmin + tdim * (double) (jtime - 1);

   // Initialize grid definition routine.

   if (first) Multint.mgrdset_(sbrgnnm, 0, 0.);

   // Loop over columns.

   for (jcol = 1; jcol <= spacetime_nmcols; ++jcol) {
      rjcol = (double) jcol;
      xcord = spacetime_xmin + ((rjcol - 1.) * spacetime_xdim);
      if (first) Multint.mgrdset_(sbrgnnm, jcol, xcord);

      // Loop for rows uses column specific step size.

      for (jrow = 1; jrow <= Multint.mintgrd_nrow[jcol - 1]; ++jrow) {
         printf_( "volume: beginning prediction at row " + jrow +
            ", column " + jcol);
         rjrow = (double) jrow;
         ycord = Multint.mintgrd_ybegin[jcol - 1]
	          + ((rjrow - 1.) * Multint.mintgrd_ydim[jcol - 1]);

	 // Check if point is in boundary.

         iblank = 0;
         dstmin = bdry_(bdry_nmbdpts[sbrgnnm - 1], bdry_xbdry[sbrgnnm - 1],
	       bdry_ybdry[sbrgnnm - 1], xcord, ycord); 
         if (dstmin < 0.) iblank = 1; 

         // Call prediction routine.

         Predict.predict_(0, 1, jrow, jcol, xcord, ycord, tmecord);
      }
   }
}

// Integrate under this surface.

volume = Multint.multint_(true);

// Write header.

if (wflag) {
   fprintf_(1, "\n ---------- Integration Under a Surface ---------------\n");
   fprintf_(1, "Volume= " + volume);
}

return volume;
}

// ---------------------------------------------------------------------

static void overlay_() {

/* Overlays discrete surface files onto the set of associated boundaries
   files.  Only does statistics, no plotting. */

String title, saveflename;

boolean newval = false;

int blank = 0, val, i, j, k, nmvals = 0, region = 0, mostrecent = 1,
   savenmfles, nmsites;

double sum, xcord, ycord, tmecord, probval = 0.;

/* The boundaries files are assumed to be in longitude-latitude coordinates.
   This method converts both the boundaries files and the surface files
   to the same cartesian coordinate system so that one never needs to
   keep track of whether each boundaries file was converted to the same
   coordinate system as the corresponding surface file. */

// If present, convert a sites file.

if (Pltsleg.plotsites) {
   savenmfles = spacetime_nminfles;
   saveflename = spacetime_infle[0];
   spacetime_nminfles = 1;
   spacetime_infle[0] = Pltsleg.sitesfle;
   spacetime_outfle = "sites.bln";
   Convrt.convrt_(0);
   Pltsleg.sitesfle = spacetime_outfle;
   spacetime_nminfles = savenmfles;
   spacetime_infle[0] = saveflename;
}

/* Convert the longitude-latitude boundaries files to a single
   cartesian coordinate system. */

spacetime_outfle = "dum.bln";
Convrt.convrt_(0);
spacetime_xmin = 0.;
spacetime_xmax = Convrt.globalxmax;
spacetime_ymin = 0.;
spacetime_ymax = Convrt.globalymax;

spacetime_bdrysfle = spacetime_outfle;
getboundaries_();

if (bdry_nmbdrys == 0) {
   iderr_("overlay: nmbdrys=0");
}

// Find per-region site counts.

if (Pltsleg.plotsites) {
   fleopen_(8, Pltsleg.sitesfle, 'r');
   printf_(fgetstrng_(8));
   printf_(fgetstrng_(8));
   nmsites = fgetint_(8);
   printf_("number of sites= " + nmsites);
   printf_(fgetstrng_(8));
   fgetint_(8);
   for (i = 0; i < nmsites; ++i) {
      xcord = fgetdble_(8);
      ycord = fgetdble_(8);
      for (j = 0; j < bdry_nmbdrys; ++j) {
         if (bdry_(bdry_nmbdpts[j], bdry_xbdry[j], bdry_ybdry[j],
             xcord, ycord) > 0.) {
            ++nmregsites[j];
	    inregn[i] = true;
            break;
         }
      }
   }
   fclose_(8, 'r');

   printf_(" Region          Number of Sites");
   for (i = 0; i < bdry_nmbdrys; ++i) {
      printf_(bdry_reglabel[i] + "   " + nmregsites[i]);
   }
}

// Convert surface files.

spacetime_outfle = "dum.sgd";
Convrt.convrt_(2);
spacetime_estmin = Convrt.globalestmin;
spacetime_estmax = Convrt.globalestmax;

// Initialize.

for (i = 0; i < bdry_nmbdrys; ++i) {
   for (j = 0; j < TNMVALS; ++j) {
      dscrtdst[i][j] = 0.;
   }
}

/* Open discrete surface file.  Read each point and find the region it is
   in.  Then, increment the corresponding value counter. */

fleopen_(4, spacetime_outfle, 'r');
title = fgetline_(4);
title = fgetline_(4);
fgetint_(4);
spacetime_nmrows = fgetint_(4);
spacetime_nmcols = fgetint_(4);
fgetdble_(4);
fgetdble_(4);
fgetdble_(4);
fgetdble_(4);
fgetdble_(4);
fgetdble_(4);

while (!checkeof_(4)) {
   xcord = fgetdble_(4);
   ycord = fgetdble_(4);
   val = (int) fgetdble_(4);
   blank = fgetint_(4);

   // Verify region membership.

   region = 0;
   for (k = 0; k < bdry_nmbdrys; ++k) {
      if (bdry_(bdry_nmbdpts[k], bdry_xbdry[k], bdry_ybdry[k],
         xcord, ycord) > 0.) {
         region = k + 1;
         break;
      }
   }
   if (blank == 1 && region > 0) {
      blank = 0;
   }

   if (blank == 0 && region == 0) {
      blank = 1;
   }

   if (blank == 0 && region > 0) {

      /* Use most-recent value to reset 0.0 values.  These values
	 occur because the digitization activity could have missed
	 some points which would then take on the default value of
	 0.0. */

      if (val == 0) {
	 val = mostrecent;

      } else {
	 mostrecent = val;
      }
      if (mostrecent <= 0) {
         iderr_("overlay: mostrecent= " + mostrecent);
      }

      // Detect the number of discrete values as the file is read.

      newval = true;
      for (i = 0; i < nmvals; ++i) {
	 if (val == values[i]) {
	    newval = false;
	    break;
	 }
      }
      if (newval) {
	 values[nmvals] = val;
	 ++nmvals;
      }

      if (Pltsurf.nmmaplevels > 0) {

	 // Transform this map-level to the desired level.

         val = Pltsurf.levelsmap[val - 1];
      }

      // Update region counts.

      dscrtdst[region - 1][val - 1] += 1.;
   }
}
fclose_(4, 'r');

// Check if expected number of map levels actually occurred.

if (Pltsurf.nmmaplevels > 0 && Pltsurf.nmmaplevels != nmvals) {
   iderr_("overlay: nmvals= " + nmvals + " nmmaplevels= " +
      Pltsurf.nmmaplevels);
}

// Compute and report distribution of surface within each region.

strng = Pltsurf.lgndlbl[0];
for (i = 1; i < Pltsurf.nmlevls; ++i) {
   strng += " " + Pltsurf.lgndlbl[i];
}

fprintf_(1, "\n ************ Overlay Relation Output ***************" +
   "\nLevels= " + strng +
   "\n\n      Region      Fractions");

for (i = 0; i < bdry_nmbdrys; ++i) {
   sum = 0.;
   for (j = 0; j < Pltsurf.nmlevls; ++j) {
      sum += dscrtdst[i][j];
   }

   if (sum > 0.) {
      strng = " ";
      for (j = 0; j < Pltsurf.nmlevls - 1; ++j) {
         dscrtdst[i][j] /= sum;
	 if (dscrtdst[i][j] == 0.) {
	    probval = .001;

	 } else if (dscrtdst[i][j] == 1.) {
	    probval = .990;

	 } else {
	    probval = dscrtdst[i][j];
	 }
	 strng += " " + fdble_(probval, 5, 3);
      }
      fprintf_(1, fstrng_(bdry_reglabel[i], 14) + strng);

   } else {
      fprintf_(1, "**** No observations at this level. ***");
   }
}

fprintf_(1, "\n----------------------------------------------------\n");

// Set surface extremes.

spacetime_estmin = 1.;
spacetime_estmax = (double) Pltsurf.nmlevls;

// Create overlaid plot.

fleopen_(3, "out.dig", 'w');
Pltsurf.pltsurf_(1, spacetime_outfle, 3, spacetime_psfle);
fclose_(3, 'w');
}

// ----------------------------------------------------------------------

static void header_(int icrval, double ydim) {

// Writes output file header information.
 
if (icrval == 0) {

   fprintf_(1, "\nLOMAP Surface Prediction");
   fprintf_(1, "grid type              = " + spacetime_grdtyp);
   fprintf_(1, "no. of rows in grid    = " + spacetime_nmrows);
   fprintf_(1, "no. of columns in grid = " + spacetime_nmcols);
   fprintf_(1, "x increment            = " + spacetime_xdim);
   fprintf_(1, "y increment            = " + ydim);

} else {
   fprintf_(1, "Cross-validation");
}
fprintf_(1, "Total number of observations    = " + nmecoobsttl);

fprintf_(1,
   "\n\n ** Kriging Results **\n" +
   "                 iblank code\n" +
   "           0: point kriged\n" +
   "           1: out of boundary, not kriged\n" +
   "           3: < 3 sites, not kriged\n" +
   "           4: ill conditioned matrix, not kriged\n" +
   "           5: sample variance = 0 inside cylinder\n");

fprintf_(1,
   "First Row of Output:\n" +
   "row  column  x  y  iblank  no. of points  matrix condition\n\n" +
   "Second Row of Output: estimate, k. variance, C.I., cv");

if (Estimate.local) {
   fprintf_(1,
      "Third Row of Output:\n" +
      "ifail  nugget  sill  range  radius\n" +
      "ifail=1: nonlinear regression failed\n" +
      "ifail=2: nugget=0 because fitted nugget < 0\n" +
      "ifail=3: nugget=sill=S**2 because fit. nug. > fit. sill");
   fprintf_(1, 
      "------------------------------------------------------------");
}

}

// -----------------------------------------------------------------------

static double sumdiffs_(double a[]) {

/* Compute sum of inter-point distances plus point-to-boundary distances.
   Compute the smallest distance of each kernel center to its nearest
   other kernel center or boundary.  This is the objective function that
   the seed initialization optimization is trying to maximize. */

int i, j, k1, k2;

double difx, dify, dist = 0., bdrydist, mindist = 1.e30, avemindist = 0.;

// Find closest distance between any 2 centers.

for (i = 0; i < nmstmixcntr; ++i) {
   k1 = 2 * i;
   for (j = 0; j < i; ++j) {
      k2 = 2 * j;
      difx = a[k1] - a[k2];
      dify = a[k1 + 1] - a[k2 + 1];
      dist = Math.sqrt(difx * difx + dify * dify);
      if (dist < mindist) mindist = dist;
   }
   bdrydist = bdry_(bdry_nmbdpts[0], bdry_xbdry[0], bdry_ybdry[0],
                    a[k1], a[k1 + 1]);
   if (bdrydist < 0.) return 0.;
   avemindist += bdrydist;
}
avemindist /= (double) nmstmixcntr;

avemindist = .999 * mindist + .001 * avemindist;

return avemindist;
}

// -----------------------------------------------------------------------

static double bdrycnstrnt_(double a[]) {

/* In support of the "sumdiffs_" routine, above, compute a constraint to
   keep the kernel seed locations inside the region's boundary. */

int i, j;

double retval;

j = 0;
for (i = 0; i < nmstmixcntr; ++i) {
   retval = bdry_(bdry_nmbdpts[0], bdry_xbdry[0], bdry_ybdry[0], a[j],
               a[j + 1]);

   if (retval < 0.) {
      return retval;
   }

   j += 2;
}

return 0.;
}

// ----------------------------------------------------------------------

static double screvalsites_(int n, int x[]) {

// Evaluate the objective function(s) at x.

int i, j, rowend, colend, nmobs, obsnmbr;

double score;

/* First, translate this move into changes in the missing value indicator
   for the subregion's sites.  Do this by first resetting all subregion
   observations to "on" and then setting observations at the deleted
   sites to "off." */

/* Old C code.  Needs fixing.
 
for (i = 0; i < n; ++i) {
   nmobs = site[subreg.siteidx[i]].nmobs;
   for (j = 0; j < nmobs; ++j) {
      obsnmbr = site[subreg.siteidx[i]].obs[j];
      if (x[i] == 1) dat2[obsnmbr].vrble = 1;
      else dat2[obsnmbr].vrble = 9;
   }
}

// Evaluate the objective function.  fcn[0] is the average prediction
// value, and fcn[1] is the average relative error.

krging_(1, 0., 0., &rowend, &colend, FALSE, FALSE);
multint_(2);
*/

/* Evaluate the objective function.  fcn[0] is the average prediction
   value, and fcn[1] is the average relative error. */

objfcn[0] = Math.abs(objfcn[0] - before[0]) / before[0];
objfcn[1] = Math.abs(objfcn[1] - before[1]) / before[1];

// Compute score function.

score = weight[0] * objfcn[0] + weight[1] * objfcn[1]; 

return score; 
}

// --------------------------------------------------------------------

static void movesites_(int n, int x[], int xtrial[]) {

/* Using the current network state "x," calculate a new state of the
   network and store it in "xtrial." */

int i, j, nmdel, nmundel, delindx, undeldx;
double frac, lower, upper;

/* Randomly select one of the deleted sites and one of the undeleted
   sites, interchange.  First, find the deleted and nondeleted sites. */

nmdel = 0;
nmundel = 0;
for (i = 0; i < n; ++i) {
   if (x[i] == 0) {
      delarry[nmdel] = i;
      ++nmdel;

   } else {
      inarry[nmundel] = i;
      ++nmundel;
   }
}

// Randomly select a deleted and undeleted site.

delindx = 0;
undeldx = 0;
frac = Rndm.rndm1_(0, 0);
for (j = 0; j < nmdel; ++j) {
   lower = (double) j / (double) (nmdel);
   upper = (double) (j+1) / (double) (nmdel);
   if (lower < frac && frac <= upper) delindx = delarry[j];
}

frac = Rndm.rndm1_(0, 0);
for (j = 0; j < nmundel; ++j) {
   lower = (double) j / (double) (nmundel);
   upper = (double) (j+1) / (double) (nmundel);
   if (lower < frac && frac <= upper) undeldx = inarry[j];
}

/* "xtrial" is identical to "x" except the selected deleted site is turned
   on and the selected undeleted site is turned off. */

for (i = 0; i < n; ++i) {
   xtrial[i] = x[i];
}

xtrial[delindx] = 1;
xtrial[undeldx] = 0;

// Update the deletion counter.

++deldst[undeldx];
}
}
