class Trendeval extends Surf {

// Constants, static variables, and arrays for Venkatram's model.

static final int MAXSTES  = 2; // was 50
static final int NMSRCE   = 4; // was 400

// Note: set MAXN to 9200, MAXCLS to 400, MAXMBRS to 200 in Id.java.

static boolean test = false, first = true;

static int nmsrce, nmwstes, m = 1;

static double uthta = 0., fthta = 0., rij = 0., kd, kw, lmbdd, lmbdw,
   lmbd4d, lmbd4w, taud, tauw, c0, zi, fw, invtw, invtd;

static double krnlwghts[] = new double[NUMCNTR];
static double kernelcnst[] = new double[NUMCNTR];
static double qso2[] = new double[NMSRCE];
static double qso4[] = new double[NMSRCE];
static double avspd[][] = new double[MAXSTES][8];
static double relfrq[][] = new double[MAXSTES][8];
static double emsloc[][] = new double[MAXN][2];
static double xwind[] = new double[MAXSTES];
static double ywind[] = new double[MAXSTES];
static double dists[][] = new double[NMSRCE][DATSZE];
static double speeds[][] = new double[NMSRCE][DATSZE];
static double frqs[][] = new double[NMSRCE][DATSZE];
static double lower[] = new double[8];
static double upper[] = new double[8];
static double quanttst[] = new double[NMQUANT];

// ---------------------------------------------------------------------

static void mixtrend_(boolean rcpflg, int rcptr, double x, double y,
   double t, double quantval[], int qualval[], int stnm, double trend[]) {

/* Evaluates the mixture spatio-temporal trend function.

   "stnm" is the number of the spatio-temporal variable, not the
   node number in the ID. */

int i, j;

double krnlsum;

// First, compute kernel weights.

krnlsum = 0.;
for (j = 0; j < nmstmixcntr; ++j) {
   krnlwghts[j] = Trendeval.mixkernel_(j + 1, x, y, t);
   krnlsum += krnlwghts[j];
}
for (j = 0; j < nmstmixcntr; ++j) {
   krnlwghts[j] /= krnlsum;
}

// Compute kernel-weighted trend for desired variables.

if (stnm == 0) {
   for (i = 0; i < parm_mvar; ++i) {
      trend[i] = 0.;
      for (j = 0; j < nmstmixcntr; ++j) {
         trend[i] += krnlwghts[j] * trendfcn_(j + 1, true, 0, x, y, t,
            quantval, qualval, stnm);
      }
   }

} else {
   trend[stnm - 1] = 0.;
   for (j = 0; j < nmstmixcntr; ++j) {
      trend[stnm - 1] += krnlwghts[j] * trendfcn_(j + 1, true, 0,
	 x, y, t, quantval, qualval, stnm);
   }
}
}

// ---------------------------------------------------------------------

static double mixkernel_(int i, double x, double y, double t) {

/* Evaluates the trend mixture kernel.  Currently, this is a 2-dimensional
   (spatial) kernel. */

double kernel = 0., difx = 0., dify = 0., dift = 0.;

kernelcnst[i - 1] = 1. / Math.sqrt(PIT2 * stmix_krnlvar[i - 1]);
if (first && i == nmstmixcntr) {
   first = false;
}

difx = x - stmix_xcntr[i - 1];
dify = y - stmix_ycntr[i - 1];

if (!spatial && temporal) {
   dift = t - stmix_tcntr[i - 1];

} else if (spatial && temporal) {
   dift = Math.abs(t - stmix_tcntr[i - 1]);
   dift = (1. - varmod_swght) * dift +
    varmod_swght * Wlstrend.sdiff_(t, stmix_tcntr[i - 1]);
}

if (spatial && !temporal) {
   kernel = .5 * (difx * difx + dify * dify) / stmix_krnlvar[i - 1];

} else if (spatial && temporal) {
   kernel = .5 * (dift * dift) / stmix_krnlvar[i - 1];
}
kernel = kernelcnst[i - 1] * Math.exp(-kernel);

if (Double.isNaN(kernel)) {
   printf_("mixkernel: i= " + i + " x= " + x + " y= " + y + " t= " + t +
      "\n xcenter= " + stmix_xcntr[i - 1] + " ycenter= " +
      stmix_ycntr[i - 1] + " tcenter= " + stmix_tcntr[i - 1] +
      " kernelcnst= " + kernelcnst[i - 1]);
   iderr_("mixkernel: kernel is NaN");
}
return kernel;
}

// ---------------------------------------------------------------------

static double trendfcn_(int cntr, boolean rcpflg, int rcptr, double x,
   double y, double t, double quantval[], int qualval[], int stnm) {

/* Evaluates either the nonmixture spatio-temporal trend function or a
   component of the mixture spatio-temporal trend function at
   x, y, t, quantval, qualval.
   
   "stnm" is the number of the spatio-temporal variable, not the
   node number in the ID.
   
   A LOMAP/GLOMAP node can be conditioned by spatio-temporal trend,
   quantitative nodes, or qualtitative nodes. */

int i, i1, j, cend, n, m, seasval;

double trend, xcenter = 0., ycenter = 0., rm, rn, xmt2, ymt2, ri, rj;

if (cntr > 0) {

   // If this is a mixture component, first load parameters.

   for (i = 0; i < nmtrendpars; ++i) {
      grdvar_rparm[stnm - 1][i] = stmix_rparm[cntr - 1][stnm - 1][i];
   }
}

cend = 0;

if (spatial) {

   // Center the location.

   xcenter = x - xmean;
   ycenter = y - ymean;
}

// Calculate the trend.

switch (itrend) {
case (10):

   // Fourier Series.

   m = 1;
   n = 1;
   rm = (double) m;
   rn = (double) n;
   xmt2 = 2. * bdry_xmax[0];
   ymt2 = 2. * bdry_ymax[0];
   trend = 0.;
   for (i = 0; i <= m; ++i) {
      for (j = 0; j <= n; ++j) {
	 ri = (double) i;
	 rj = (double) j;
	 trend += grdvar_rparm[stnm - 1][cend]
         * Math.cos(Math.PI * ri * (2. * x - bdry_xmax[0]) / xmt2)
         * Math.cos(Math.PI * rj * (2. * y - bdry_ymax[0]) / ymt2)
       + grdvar_rparm[stnm - 1][cend + 1]
         * Math.sin(Math.PI * ri * (2. * x - bdry_xmax[0]) / xmt2)
         * Math.cos(Math.PI * rj * (2. * y - bdry_ymax[0]) / ymt2)
       + grdvar_rparm[stnm - 1][cend + 2]
         * Math.cos(Math.PI * ri * (2. * x - bdry_xmax[0]) / xmt2)
         * Math.sin(Math.PI * rj * (2. * y - bdry_ymax[0]) / ymt2)
       + grdvar_rparm[stnm - 1][cend + 3]
         * Math.sin(Math.PI * ri * (2. * x - bdry_xmax[0]) / xmt2)
         * Math.sin(Math.PI * rj * (2. * y - bdry_ymax[0]) / ymt2);
         cend += 4;
      }
   }
   return trend;

case (11):

   // Venkatram's compartment model.

   trend = cmpmdl_(rcpflg, rcptr, x, y);

   return trend;
}

// Polynomial regression models.

trend = grdvar_rparm[stnm - 1][cend];

if (itrend > 4) {
   if (spatial) {
      trend += grdvar_rparm[stnm - 1][cend+1] * xcenter +
	 grdvar_rparm[stnm - 1][cend + 2] * ycenter;
      cend += 2;

   } else {
      trend += grdvar_rparm[stnm - 1][cend + 1] * t;
      ++cend;
   }
}

if (itrend > 5) {
   if (spatial) {
      trend += grdvar_rparm[stnm - 1][cend+1] * xcenter * xcenter +
         grdvar_rparm[stnm - 1][cend + 2] * ycenter * ycenter +
         grdvar_rparm[stnm - 1][cend + 3] * xcenter * ycenter;
      cend += 3;

   } else {
      trend += grdvar_rparm[stnm - 1][cend + 1] * t * t;
      ++cend;
   }
}

if (nonlin) trend = 1./trend; 

// Add effect of covariate(s).

if (quantvarmodel > 0) {
   for (i1 = 0; i1 < nmquantvar; ++i1) {
      trend += grdvar_rparm[stnm - 1][cend + i1] * quantval[i1];
   }
   cend += nmquantvar;

   if (quantvarmodel == 2) {
      for (i1 = 0; i1 < nmquantvar; ++i1) {
	 trend += grdvar_rparm[stnm - 1][cend + i1]
	       * quantval[i1] * quantval[i1];
      }
      cend += nmquantvar;
   }
}

// Temporal trend in a spatio-temporal polynomial.

if (spatial && temporal) {
   ++cend;
   trend += grdvar_rparm[stnm - 1][cend] * t;

/*
   ++cend;
   trend += grdvar_rparm[stnm - 1][cend] * t * t;
*/

   if (seasclc) {

      /* Sinusoidal seasonality.
      ++cend;
      trend += ( grdvar_rparm[stnm - 1][cend]
	 * Math.cos(2. * Math.PI * t * .25)
	 + grdvar_rparm[stnm - 1][cend+1]
	 * Math.sin(2. * Math.PI * t * .25) ); */

      // Simple ANOVA seasonality.

      ++cend;
      seasval = Wlstrend.getseas_(t);
      if (seasval == 1) { // Winter.
         trend += grdvar_rparm[stnm - 1][cend];

      } else if (seasval == 2) { // Spring.
         trend += grdvar_rparm[stnm - 1][cend + 1];

      } else if (seasval == 3) { // Summer.
         trend += grdvar_rparm[stnm - 1][cend + 2];

      } else if (seasval == 4) { // Fall.
         trend -=
	    (grdvar_rparm[stnm - 1][cend]
            + grdvar_rparm[stnm - 1][cend + 1]
            + grdvar_rparm[stnm - 1][cend + 2]);
      }
      cend += 2;
   }
}

// Add qualitative variables.

for (i = 1; i <= nmqualvar; ++i) {
   if (qualval[i - 1] < nmquallvl[i - 1]) {
      trend += grdvar_rparm[stnm - 1][cend + qualval[i - 1]];
   
   } else {
      for (j = 1; j < nmquallvl[i - 1]; ++j) {
         trend -= grdvar_rparm[stnm - 1][cend + j];
      }
   }
   cend += nmquallvl[i - 1] - 1;
}

return trend;
}

// ----------------------------------------------------------------------

static double cmpmdl_(boolean rcpflg, int j, double xcord,
   double ycord) {

/* Returns the deposition at coordinate (xcord,ycord) using Venkatram's
   1988 compartmental physical process model.
   If rcpflg is true, this is receptor j, otherwise, this is a new,
   unknown receptor location, (xcord, ycord).

   Units: distance = km, mass = kg, time = seconds.

   Variables:
      y[0] = grams of S that exist as dry so2
      y[1] = grams of S that exist as wet so2
      y[2] = grams of S that exist as dry so4
      y[3] = grams of S that exist as wet so4.

   Parameters:
      kd     = dry so2 to so4 transformation rate,
      kw     = wet so2 to so4 transformation rate,
      lmbdd  = dry so2 scavenging coefficient
      lmbdw  = wet so2 scavenging coefficient
      lmbd4d = dry so4 scavenging coefficient
      lmbd4w = wet so4 scavenging coefficient
      taud   = Lagrangian dry period duration
      tauw   = Lagrangian wet period duration
      c0     = oxidant concentration.                  */

int i, jj, nok, nbad, nmclsrc, retval = 0;
double zi, captij, tij, denom, tauw, dij, dj, lmbdw, lmbd4w, taud, fd, fw;
double y[] = new double[4];

/* Upon first call, read source locations and emission rates.  Also read
   average wind speed and direction frequencies. */

if (first) {
   wind_(first, false, 0, 0, xcord, ycord);
   first = false;
}

taud = grdvar_rparm[0][6];
tauw = grdvar_rparm[0][7];
fd = taud / (taud + tauw);
fw = 1. - fd;

lmbdw = grdvar_rparm[0][1];
lmbd4w = grdvar_rparm[0][3];
zi = grdvar_rparm[0][9];

// Compute deposition.

nmclsrc = 0;
dj = 0.;
for (i = 0; i < nmsrce; ++i) {
   
   // Get constants for this source, receptor pair.

   wind_(first, rcpflg, i, j, xcord, ycord);

   /* If the source and receptor are too far apart, skip.  Note that
      the units of rij are kilometers * 1000. */

   if (rij < 1.0) {
      ++nmclsrc;
      grdvar_rparm[0][ nmpars[0] ] = uthta;

      rij *= 1.e6;
      captij = fthta / (2. * Math.PI * rij * uthta * zi);
      tij = rij / uthta;
      rij *= 1.e-6;

      /* 0.2618 is 15 degrees expressed in radians but Venkatram is
	 apparently using degrees. */

      denom = .2618 * zi * uthta;

      // Solve the DE system.  First, find initial conditions.

      y[0] = fd * qso2[i] / denom;
      y[1] = fw * qso2[i] / denom;
      y[2] = fd * qso4[i] / denom;
      y[3] = fw * qso4[i] / denom;

      iderr_("odeint not translated");
      // retval = odeint_(y, 4, 0., tij, 1.e-3, tij * .001, tij * .00001,
      //    &nok, &nbad);
      if (retval == 1) {
         printf_( grdvar_rparm[0][0] + " " + grdvar_rparm[0][1] + " " +
	    grdvar_rparm[0][2] + " " + grdvar_rparm[0][3]);
	 printf_( grdvar_rparm[0][4] + " " + grdvar_rparm[0][5] + " " +
	    grdvar_rparm[0][6] + " " + grdvar_rparm[0][7]);
         printf_("odeint failed.");
	 return -1.e30;
      }

      /* Compute the wet deposition at location (xcord, ycord) due to
         emissions from i^th source. */

      dij = zi * (lmbdw * y[1] + lmbd4w * y[3]) * captij;
      dj += dij;
   }
}
if (nmclsrc == 0) iderr_("no close sources in cmpmdl_()");

return dj;
}

// ----------------------------------------------------------------------

static void wind_(boolean first, boolean rcpflg, int i, int j,
   double xcord, double ycord) {

/* Computes average wind speed in the direction from source to receptor
   and the relative frequency of this wind.  The vector between source
   and receptor is:
   source i --> receptor j     (rcpflg) or
   source i --> (xcord, ycord) (!rcpflg).

   On first call, wind speed, direction, and frequency data are read.
   Also on first call, emission data is read. */

int i1, jj;
int clusmem[][] = new int[MAXCLS][MAXMBRS];
int nmmmbrs[] = new int[MAXCLS];
int shift[] = new int[8];
double frqsum;
double clscntr[][] = new double[MAXCLS][2];
double so2stre[] = new double[MAXN];

// First call initialization.

if (first) {

   /* Store angle bounds and set up shift array to translate between
      north=0, clockwise degrees and an the east=0, counterclockwise
      system. */

   lower[0] = 0.;
   upper[0] = Math.PI / 4.;
   for (i1 = 1; i1 < 8; ++i1) {
      lower[i1] = upper[i1 - 1];
      upper[i1] = lower[i1] + Math.PI / 4.;
   }
   shift[0] = 6;
   shift[1] = 5;
   shift[2] = 4;
   shift[3] = 3;
   shift[4] = 2;
   shift[5] = 1;
   shift[6] = 8;
   shift[7] = 7;

   // Read wind rose file.

   fleopen_(5, "wndcon.dat", 'r');
   i1 = 0;
   while (checkeof_(5) != true) {
      xwind[i1] = fgetdble_(5);
      ywind[i1] = fgetdble_(5);
      frqsum = 0.;
      for (jj = 0; jj < 8; ++jj) {
	 avspd[i1][shift[jj] - 1] = fgetdble_(5);
	 relfrq[i1][shift[jj] - 1] = fgetdble_(5);
	 frqsum += relfrq[i1][shift[jj] - 1];
      }
      if (Math.abs(frqsum - 1.) > 1.e-5) {
	 printf_("frqsum= " + frqsum);
	 iderr_("frqsum!=1 in cmpmdl");
      }
      ++i1;
      if (i1 > MAXSTES) iderr_("i1>MAXSTES in wind_()");
   }
   fclose_(5, 'r');

   nmwstes = i1;
   printf_("Number of wind rose sites= " + nmwstes);

   // Read emissions file.

   fleopen_(5, "emitcon.dat", 'r');
   i1 = 0;
   while (checkeof_(5) != true) {
   emsloc[i1][0] = fgetdble_(5);
   emsloc[i1][1] = fgetdble_(5);
   so2stre[i1] = fgetdble_(5);

      // Convert to kg: 1 short ton = 907.2 kg = 907200.0 g.

      so2stre[i1] *= 907200. * 1.e3;

      ++i1;
      if (i1 > MAXN) iderr_("too many sources in wind_()");
   }
   fclose_(5, 'r');
   printf_("Number of raw sources= " + i1);

   // Perform clustering to reduce the number of sources.

   nmsrce = 400;
   if (nmsrce > NMSRCE) iderr_("nmsrce>NMSRCE in wind_()");

   Clstr.clstr_(2, i1, emsloc, nmsrce, nmmmbrs, clusmem, clscntr);

   /* Replace original emissions data with cluster centers and cluster
      sums.  Also assume the proportion of the observed total is 98%
      SO2 and 2% SO4 (Venkatram, AE 1982). */

   for (i1 = 0; i1 < nmsrce; ++i1) {
      emsloc[i1][0] = clscntr[i1][0];
      emsloc[i1][1] = clscntr[i1][1];
      qso2[i1] = 0.;
      for (jj = 0; jj < nmmmbrs[i1]; ++jj) {
	 qso2[i1] += so2stre[clusmem[i1][jj] - 1];
      }
      qso4[i1] = .02 * qso2[i1];
      qso2[i1] *= .98;
   }

   /* Now compute and store the distance (in 1000*km) between each
      source and each monitoring site (receptor), store in "dists."
      Also compute average wind speed and relative frequencis over
      the 8 direction classes for each source-monitoring site pair. */

   for (i1 = 0; i1 < nmsrce; ++i1) {
      for (jj = 0; jj < nmecoobsttl; ++jj) {
	 spdfrq_(nmwstes, vardat_x[jj], vardat_y[jj], emsloc[i1][0],
	    emsloc[i1][1], lower, upper, xwind, ywind, avspd, relfrq);
	 dists[i1][jj] = rij;
	 speeds[i1][jj] = uthta;
	 frqs[i1][jj] = fthta;
      }
   }
}

/* Compute or look up distance between source and receptor, uthta,
   and fthta. */

if (!rcpflg) {
   spdfrq_(nmwstes, xcord, ycord, emsloc[i][0], emsloc[i][1], lower,
      upper, xwind, ywind, avspd, relfrq);

} else {
   rij = dists[i][j];
   uthta = speeds[i][j];
   fthta = frqs[i][j];
}
}

// -------------------------------------------------------------------

static void spdfrq_(int nmwstes, double xcord, double ycord,
   double xsrce, double ysrce, double lower[], double upper[],
   double xwind[], double ywind[], double avspd[][], double relfrq[][]) {

/* Computes length, average speed and direction relative frequencies for
   the vector from (xsrce, ysrce) to (xcord, ycord).
   Note that rij and all other variables are in kilometers * 1000. */

int i1, clss;
int indx[] = new int[MAXSTES];
double dx, dy, xmid, ymid, slope, intcpt, capa, capb, capc, thta;
double dist[] = new double[MAXSTES];

dx = xcord - xsrce;
dy = ycord - ysrce;
rij = Math.sqrt(dx * dx + dy * dy);
xmid = .5 * (xcord + xsrce);
ymid = .5 * (ycord + ysrce);

/* Compute angle between source and receptor, find angle class this
   angle belongs to, find closest m wind sites to the line connecting
   source and receptor, and find the average wind speed and relative
   frequency of these wind sites within this angle class. */

slope = dy / dx;
intcpt = ycord - slope * xcord;
capa = 1. / intcpt;
capb = 1. / slope;
capc = -1.;
thta = Math.atan2(dy, dx);
if (thta < 0.) thta = 2. * Math.PI + thta;
clss = 0;
for (i1 = 1; i1 <= 8; ++i1) {
   if (lower[i1 - 1] <= thta && thta <= upper[i1 - 1]) {
      clss = i1;
      break;
   }
}

/* Find the m closest wind sites to the line connecting (xcord, ycord)
   and the i^th source.  Specifically, let
   dist = dist_to_line + dist_to_midpoint. */

for (i1 = 0; i1 < nmwstes; ++i1) {
   dist[i1] = capa * xwind[i1] + capb * ywind[i1] + capc;
   dist[i1] /= Math.sqrt(capa * capa + capb * capb);
   if (dist[i1] < 0.) dist[i1] *= -1.;
   dx = xwind[i1] - xsrce;
   dy = ywind[i1] - ysrce;
   dist[i1] = Math.sqrt(dx * dx + dy * dy);
   indx[i1] = i1;
}

/* Now find the average within-class wind speed and average within-class
   frequency over these m closest sites. */

Idsort.idsort_(dist, indx, 1, nmwstes);
uthta = 0.;
fthta = 0.;
for (i1 = 0; i1 < m; ++i1) {
   uthta += avspd[indx[i1]][clss - 1];
   fthta += relfrq[indx[i1]][clss - 1];
}
uthta /= (double) m;
fthta /= (double) m;
}

// ---------------------------------------------------------------------

static void derivs_(double x, double y[], double dydx[]) {

// Computes rhs of Venkatram's DE system.

int i;

double uthta, r, cso2w;

if (odefirst) {
   lmbdd = grdvar_rparm[0][0];
   lmbdw = grdvar_rparm[0][1];
   lmbd4d = grdvar_rparm[0][2];
   lmbd4w = grdvar_rparm[0][3];
   kd = grdvar_rparm[0][4];
   kw = grdvar_rparm[0][5];
   taud = grdvar_rparm[0][6];
   tauw = grdvar_rparm[0][7];
   c0   = grdvar_rparm[0][8];
   zi   = grdvar_rparm[0][9];

   fw = 1. - taud / (taud + tauw);
   invtw = 1. / tauw;
   invtd = 1. / taud;
   odefirst = false;
}

// r is distance from source.

uthta = grdvar_rparm[0][ nmpars[0] ];
r = uthta * x;

// Compute wet so2 concentration, 15 degrees = .2618 radians.

cso2w = y[1] / (fw * r * .2618 * zi * uthta);

dydx[0] = y[0] * (-kd - lmbdd - invtd) + y[1] * invtw;
if (cso2w > c0) {
   dydx[1] = y[1] * (-kw - lmbdd - invtw) - lmbdw * c0 * r * fw
	     + y[0] * invtd;

} else {
   dydx[1] = y[1] * (-kw - lmbdd - invtw - lmbdw) + y[0] * invtd;
}
dydx[2] = y[0] * kd - y[2] * (lmbd4d + invtd) + y[3] * invtw;
dydx[3] = y[1] * kw + y[2] * invtd - y[3] * (lmbd4d + invtw + lmbd4w);
}

// -----------------------------------------------------------------------

static void quantqual_(double xcord, double ycord, double tmecord,
   double quantval[], int qualval[]) {

// Finds the value of the covariate at the location xcord, ycord.

int i;

double xmin, ymin, dx, dy, x, y, dist, distmin, time;

if (nmquantvar == 0) return;

if (first == true) {
   printf_("quantqual: opening elevrob.xy");
   fleopen_(27, "elevrob.xy", 'r');
   first = false;
}

// Find the closest quantitative node location.

distmin = 1.e30;
for (;;) {
   x = fgetdble_(27);
   y = fgetdble_(27);

   for (i = 0; i < nmquantvar; ++i) quanttst[i] = fgetdble_(27);
   if (checkeof_(27)) break;

   dx = xcord - x;
   dy = ycord - y;
   dist = Math.sqrt(dx * dx + dy * dy);
   if (dist < distmin) {
      xmin = x;
      ymin = y;
      distmin = dist;
      for (i = 0; i < nmquantvar; ++i) quantval[i] = quanttst[i];
   }
}

if (nmqualvar == 0) return;

/* For now, use values of closest data point for qualtitative node
   values (the vardat structure contains values that are sorted
   according to their distance from the prediction location. */

for (i = 0; i < nmqualvar; ++i) qualval[i] = vardat_qualval[0][i];
           
/*
gprint("xmin=%lf ymin=%lf distmin=%lf covrte1=%lf covrte2=%lf\n",
   xmin, ymin, distmin, covrte[0], covrte[1]);
*/
}
}
