public class Update extends Beliefs {

static boolean chkflag = false;

static int intprntvals[][] = new int[NMTHRDS][TNMPRTS];

static double prntvals[][] = new double[NMTHRDS][TNMPRTS];
static double yn[][] = new double[NMTHRDS][MAXNMSDE];

// ----------------------------------------------------------------

public static int update_(int thrd, double nodevals[][][], int node,
   int dst) {

/* For network distribution, dst, samples a value of node from node's
   conditional distribution (conditioned on the current values of the
   parents) and writes this value to the current node value array,
   "nodevals."
   
   "nodevals[thrd][0][.]" contains the previous time step's node values,
   "nodevals[thrd][1][.]" contains the current time step's node values.
   
   dst=1: hypothesis distribution,
   dst=2: consistent distribution.

   Available deterministic functions and probability distributions:

   1. Deterministic nodes --
      a) Determ_Root:     Deterministic root node.

      b) Determ_Contin:   Deterministic node having a continuous value
			  indexed by the parent's value.

      c) Determ_Linear:   Parametric linear function of all parent
                          values (value = constant + sum(parm_i * parent_i)
                          First parameter is a constant.

      d) Determ_Ratio:    Ratio of Parent 1 to Parent 2.

      e) Determ_Thrshld:  0 if parent is below threshold parameter,
                          1 if not.

      f) Determ_Frctn:    0 if parent is below a lower threshold,
                          between 0 and 1 if parent is between lower and
                          upper thresholds, and 1 if parent is above the
                          upper threshold.

      g) Determ_Loss:     Quadratic loss function centered at beta_0 and
                          scaled by beta_1.

      h) Determ_Discrete: Discrete function of parent value pattern: one
                          value for each pattern.  Has only a finite
			  number of values whose labels are listed in the
			  .id file

      i) Determ_Function: Parametric nonlinear function of parent values.
                          (not programmed yet)

   2. Discrete:           Discrete node with tabulated probabilities.

   3. Logit:              Cumulative Logit.

   4. Normal:             Normal with mean mu and variance sigma^2.

   5. Lognormal:          Lognormal with log-scale mean equal to mu,
			  log-scale variance equal to sigma^2.

   6. Beta:               Beta distribution with parameters a and b.

   7. Gamma:              Gamma with shape parameter alphag and scale
			  parameter betag.

   8  LOMAP, GLOMAP:      LOcal Model And Predictor (local
			  spatio-temporally), GLObal Model And Predictor.

   9. SDE:                System of Stochastic Differential Equations with
		          several parameters.

  10. HIBM:               Herbivore Individual-Based Model with several
                          parameters.
  
  10. PIBM:               Predator Individual-Based Model with several
                          parameters.
  
  11. SMS:                Stochastic Movement Simulator with several
                          parameters.
*/

int i, j, j1, j2, k, l, prntnode = 0, ngh1, ngh2, nmvalngh1, nmvalngh2,
   nmvals, nmprnts, prntnm1, prntnm2, prntnm3, parnm, dstm1 = dst - 1;

double upper, mu, mu_l, sigma2, alphag, betag, val = 0., b0, b1, prob = 0.,
   explogit = 0., newval, oldval, prob1, prob2, probdiff;

/* If "node" is a root node and is also in the conditioning set, set
   "nodevals" to the conditioning value and return. */


for (k = 1; k <= nmcondnds; ++k) {
   if (node == condnodes[idnmbrm1][k - 1] &&
       nodenghs[idnmbrm1][node - 1][1] == 0) {
      nodevals[thrd][1][node - 1] = condvals[k - 1];
      nodevals[thrd][0][node - 1] = condvals[k - 1];
   
      return 0;
   }
}

/* For an ID with time-stepping functions, don't update a
   temporally-independent node after the initial time. */

if (nmtmefcns[idnmbrm1] > 0 && !varinfo_temporal[idnmbrm1][node - 1] &&
   beltmept[thrd] > Ecosyscalcs.tbegin) {

   return 0;
}

/*
if (thisidname.equals("tigereco")) {
   printf_("update: setting parent values: tbegin= " + Ecosyscalcs.tbegin +
      " node= " + node + " Manopvalue= " + nodevals[thrd][1][1]);
}
*/

/* Get number of values and number of parents.  Initialize parent values
   array to the value 1.0. */

nmvals = nodenghs[idnmbrm1][node - 1][0];
nmprnts = nodenghs[idnmbrm1][node - 1][1];
for (k = 0; k < TNMPRTS; ++k) {
   prntvals[thrd][k] = 1.;
   intprntvals[thrd][k] = 1;
}

// Get current values of node's parents.

/*
printf_("longname= " + nodelbls[idnmbrm1][node - 1][0] + " dist= " +
   varinfo_dist[idnmbrm1][node - 1]);
*/

for (k = 0; k < nmprnts; ++k) {
   prntnode = nodenghs[idnmbrm1][node - 1][k + 2];
   if (prntnode == 0) {
      printf_("update: nmthreads= " + nmthreads + 
         " thrd= " + thrd + " idnmbrm1= " + idnmbrm1 + " node= " +
	 node + " nmprnts= " + nmprnts +
	 "\n   prnt= " + (k + 1));
      iderr_("   prntnode= " + prntnode);
   }

   prntvals[thrd][k] = nodevals[thrd][0][prntnode - 1];
   intprntvals[thrd][k] = (int) prntvals[thrd][k];

   if (nodelbls[idnmbrm1][prntnode - 1][0].equals("Time")) {
      intprntvals[thrd][k] = 1;
   
   } else if (varinfo_dist[idnmbrm1][node - 1].equals("Discrete") &&
      intprntvals[thrd][k] == 0) {
      iderr_("update: node= " + nodelbls[idnmbrm1][node - 1][0] +
	 " parent " + (k + 1) + " =0");

   } else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Contin") &&
       Math.abs(intprntvals[thrd][k]) > TNMVALS) {
      intprntvals[thrd][k] = 1;

   } else if ( varinfo_dist[idnmbrm1][prntnode - 1].equals("R_Horn_ABM") ||
      varinfo_dist[idnmbrm1][prntnode - 1].equals("M_Network_ABM")) {
      intprntvals[thrd][k] = 1;
   }
}

/* Compute the node's deterministic function value or sample from node's
   conditional distribution. */

// ------------------- Deterministic functions. ------------------------

if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Linear")) {

   // Linear function: y = parm1 + parm2 * parent_value.

   prntnm1 = nodenghs[idnmbrm1][node - 1][2];
   prntnm2 = nodenghs[idnmbrm1][node - 1][3];
   prntnm3 = nodenghs[idnmbrm1][node - 1][4];
   if ((nmprnts == 1 && nodenghs[idnmbrm1][prntnm1 - 1][0] == 1) ||
       (nodenghs[idnmbrm1][prntnm1 - 1][0] == 1 &&
        nodenghs[idnmbrm1][prntnm2 - 1][0] == 1)) {

      // One or two continuously valued parents.

      nodevals[thrd][1][node - 1] = 0.;
      parnm = -1;
      for (k = 0; k < nmprnts; ++k) {
         ++parnm;
         nodevals[thrd][1][node - 1] += condprb[idnmbrm1][node - 1][parnm]
                                               [0][0][0][0][0][0][dstm1];
         ++parnm;
         nodevals[thrd][1][node - 1] +=
            condprb[idnmbrm1][node - 1][parnm][0][0][0][0][0][0][dstm1] *
            prntvals[thrd][k];
 
	 /*
         if (thrd == 1 && thisidname.equals("cheetaheco") &&
            nodelbls[idnmbrm1][node - 1][0].equals("Cheetah_Abundance")) {
            printf_("update: k= " + k + " condprb= " +
               condprb[idnmbrm1][node - 1][parnm][0][0][0][0][0][0][dstm1] +
               " prntvals= " + prntvals[thrd][k] + " nodevals= " +
               nodevals[thrd][1][node - 1]);
         }
	 */
      }

   } else if (nodenghs[idnmbrm1][prntnm1 - 1][0] > 1 &&
              nodenghs[idnmbrm1][prntnm2 - 1][0] == 1) {

      /* Discrete first parent, continuous second parent.  Note that
         the second parent is continuously-valued so its conditioning
         value in the "condprb" array is 0. */

      parnm = 0;
      k = intprntvals[thrd][0];
      nodevals[thrd][1][node - 1] = condprb[idnmbrm1][node - 1][parnm]
                                       [k - 1][0][0][0][0][0][dstm1];
      ++parnm;
      nodevals[thrd][1][node - 1] += condprb[idnmbrm1][node - 1][parnm]
                                        [k - 1][0][0][0][0][0][dstm1] *
                                     prntvals[thrd][1];

   } else if (nodenghs[idnmbrm1][prntnm1 - 1][0] > 1 &&
              nodenghs[idnmbrm1][prntnm2 - 1][0] > 1 &&
              nodenghs[idnmbrm1][prntnm3 - 1][0] == 1) {

      /* First two parents are discrete, third parent is continuous.
         Interaction effects across different combinations of discrete
         parent values can be modeled with different values of this
         parameter across different parent value patterns contained in the
         hypothesis parameter file. */

      k = intprntvals[thrd][0];
      l = intprntvals[thrd][1];
      nodevals[thrd][1][node - 1] = condprb[idnmbrm1][node - 1][0]
                                       [k - 1][l - 1][0][0][0][0][dstm1] *
                                    prntvals[thrd][2];

   } else {
      iderr_("update: invalid parents of a Determ_Linear node"); 
   }

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Ratio")) {

   // Ratio of Parent 1 to Parent 2.

   if (prntvals[thrd][1] == 0.) {
      iderr_("update: parent 2 = 0");
   }
   nodevals[thrd][1][node - 1] =
      prntvals[thrd][0] / prntvals[thrd][1];

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Thrshld")) {

   // Binary-valued threshold node.

   if (prntvals[thrd][0] > condprb[idnmbrm1][node - 1]
			    [0][0][0][0][0][0][0][dstm1]) {
      nodevals[thrd][1][node - 1] = 2.;
      
   } else {
      nodevals[thrd][1][node - 1] = 1.;
   }

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Frctn")) {

   /* Fraction of a region over which a species has been detected.
      Parameterized by upper and lower density limits.  First, compute
      the density.  This assumes that the area node is the second
      parent. */

   prntvals[thrd][0] /= prntvals[thrd][1];

   if (prntvals[thrd][0] < condprb[idnmbrm1][node - 1][0]
			    [0][0][0][0][0][0][dstm1]) {
      nodevals[thrd][1][node - 1] = 0.;

   } else if (prntvals[thrd][0] > condprb[idnmbrm1][node - 1][1]
				   [0][0][0][0][0][0][dstm1]) {
      nodevals[thrd][1][node - 1] = 1.;

   } else {
      nodevals[thrd][1][node - 1] =
         condprb[idnmbrm1][node - 1][1][0][0][0][0][0][0][dstm1] -
            condprb[idnmbrm1][node - 1][0][0][0][0][0][0][0][dstm1];
      nodevals[thrd][1][node - 1] = (prntvals[thrd][0] -
         condprb[idnmbrm1][node - 1][0][0][0][0][0][0][0][dstm1]) /
         nodevals[thrd][1][node - 1];
   }

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Loss")) {

   // Asymmetric loss function.

/*
   b0 = condprb[idnmbrm1][node - 1][0][0][0][0][0][0][0][dstm1];
   b1 = condprb[idnmbrm1][node - 1][1][0][0][0][0][0][0][dstm1];
   if (nodevals[thrd][1][node - 1] < b0) {
      nodevals[thrd][1][node - 1] = 10. * (prntvals[thrd][0] - b0);
      nodevals[thrd][1][node - 1] =
         Math.pow(nodevals[thrd][1][node - 1], 10. * b1);
   
   } else {
      nodevals[thrd][1][node - 1] = 10. * (prntvals[thrd][0] - b0);
      nodevals[thrd][1][node - 1] =
         Math.pow(nodevals[thrd][1][node - 1], b1);
   }
*/
   if (prntvals[thrd][0] < .15) {
      nodevals[thrd][1][node - 1] = 10000.;
   
   } else if (.15 <= prntvals[thrd][0] && prntvals[thrd][0] < .5) {
      nodevals[thrd][1][node - 1] = 1.;
   
   } else if (.5 <= prntvals[thrd][0] && prntvals[thrd][0] < .8) {
      nodevals[thrd][1][node - 1] = 5.;
   
   } else if (.8 <= prntvals[thrd][0]) {
      nodevals[thrd][1][node - 1] = 10.;
   
   } else {
      iderr_("beliefs: prntvals= " + prntvals[thrd][0]);
   }

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Discrete") ||
           varinfo_dist[idnmbrm1][node - 1].equals("Determ_Contin")) {

   /* Deterministic discrete value (Determ_Discrete) or deterministic
      continuous value (Determ_Contin) determined by the conditioning
      pattern.  Note that the difference between these two nodes is that
      the discrete values are labeled in the .id file.  Use a Determ_Contin
      node for utility. */

   try {
   nodevals[thrd][1][node - 1] = condprb[idnmbrm1][node - 1][0]
	       [intprntvals[thrd][0] - 1][intprntvals[thrd][1] - 1]
	       [intprntvals[thrd][2] - 1][intprntvals[thrd][3] - 1]
               [intprntvals[thrd][4] - 1][0][dstm1];
   }
   catch (Exception e) {
   iderr_("update: ID= " + thisidname + " node= " + node + " node label= " +
      nodelbls[idnmbrm1][node - 1][0] + " dst= " + dst +
      "\n   intprntvals= " + intprntvals[thrd][0] + " " +
      intprntvals[thrd][1] + " " + intprntvals[thrd][2] + " " +
      intprntvals[thrd][3] + " " + intprntvals[thrd][4] +
      "\n   array bounds problem");
   }

   if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Discrete") &&
       nodevals[thrd][1][node - 1] < 1.) {
      iderr_("update: ID= " + thisidname + " node= " +
	 nodelbls[idnmbrm1][node - 1][0] + " Determ_Discrete nodevals= " +
	 nodevals[thrd][1][node - 1]);
   }

   if (thisidname.equals("kenpres") &&
       varinfo_dist[idnmbrm1][node - 1].equals("Determ_Contin") &&
       dst == 2 && Conddist.firstloop) {
       // printf_("update: nodevals1= " + nodevals[thrd][1][node - 1]);
   }

   /*
   if (grph_label[idnmbrm1][node - 1].equals("SMILRCHG") && dst == 2 &&
       intprntvals[thrd][0] == 15) {
      printf_("update: nodevals= " + nodevals[thrd][1][node - 1]);
   }
   */

   /*
   if (thisidname.equals("kenpres") &&
       varinfo_dist[idnmbrm1][node - 1].equals("Determ_Contin")) &&
       !(Math.abs(nodevals[thrd][1][node - 1] - .5) < 1.e-6)  &&
       !(Math.abs(nodevals[thrd][1][node - 1]) < 1.e-6)) {
         iderr_("update: utility= " + nodevals[thrd][1][node - 1]);
      }
   }
   */

   /*
   oldval = condprb[idnmbrm1][node - 1][0]
	       [intprntvals[thrd][0] - 1][intprntvals[thrd][1] - 1]
	       [intprntvals[thrd][2] - 1][intprntvals[thrd][3] - 1]
               [intprntvals[4] - 1][0][0];
   newval = condprb[idnmbrm1][node - 1][0]
	       [intprntvals[thrd][0] - 1][intprntvals[thrd][1] - 1]
	       [intprntvals[thrd][2] - 1][intprntvals[thrd][3] - 1]
               [intprntvals[4] - 1][0][1];
   if (oldval != newval) {
      printf_("update: dst= " + dst + " oldval= " + oldval +
	 " newval= " + newval);
   }
   */

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Determ_Temporal")) {

   // Deterministic function of a continuously-valued parent.

   nodevals[thrd][1][node - 1] = 1;
   for (i = 0; i < nmvals; ++i) {
      try {
      val = condprb[idnmbrm1][node - 1][i]
	       [intprntvals[thrd][0] - 1][intprntvals[thrd][1] - 1]
	       [intprntvals[thrd][2] - 1][intprntvals[thrd][3] - 1]
               [intprntvals[thrd][4] - 1][0][dstm1];
      }
      catch (Exception e) {
      iderr_("update: node= " + node + " node label= " +
         nodelbls[idnmbrm1][node - 1][0] + " dst= " + dst +
         "\n   intprntvals= " + intprntvals[thrd][0] + " " +
         intprntvals[thrd][1] + " " + intprntvals[thrd][2] + " " +
         intprntvals[thrd][3] + " " + intprntvals[thrd][4] +
         "\n   array bounds problem");
      }
      if (Math.abs(prntvals[thrd][0] - val) < .15) {
         nodevals[thrd][1][node - 1] = (i + 1);
         break;
      }
   }
   
   /*
   printf_("update: Time= " + prntvals[thrd][0] + " actiontime= " +
      val + " nodevals= " + nodevals[thrd][1][node - 1]);
   */

// --------------- Beginning of stochastic nodes. ----------------------

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Discrete") ||
           (varinfo_dist[idnmbrm1][node - 1].equals("Logit") &&
	   nmprnts == 4)) {

   // Discrete random node with tabulated probabilities ("classic" BBN).

   /*
   if (phenomenon_class[idnmbrm1].equals("ecosystem")) {
      printf_("update: node= " + node + " prntvals= " +
         prntvals[thrd][0] + " " + prntvals[thrd][1] + " " +
	 prntvals[thrd][2] + " " + prntvals[thrd][3] + " " +
	 prntvals[thrd][4] + " dst= " + dst + 
         "\n    intprntvals= " + intprntvals[thrd][0] + " " +
	 intprntvals[thrd][1] + " " + intprntvals[thrd][2] +
	 " " + intprntvals[thrd][3] + " " + intprntvals[thrd][4]);
   }
   */

   if (varinfo_dist[idnmbrm1][node - 1].equals("Logit")) {
      intprntvals[thrd][2] = 1;
      intprntvals[thrd][3] = 1;
   }

   upper = 0.;
   try {
   upper = condprb[idnmbrm1][node - 1][0][intprntvals[thrd][0] - 1]
              [intprntvals[thrd][1] - 1][intprntvals[thrd][2] - 1]
	      [intprntvals[thrd][3] - 1][intprntvals[thrd][4] - 1]
	      [0][dstm1];
   }
   catch (Exception e) {
   iderr_("update: idnmbrm1= " + idnmbrm1 + " discrete node= " + node +
      " node label= " + nodelbls[idnmbrm1][node - 1][0] + " dst= " + dst +
      "\n   intprntvals= " + intprntvals[thrd][0] + " " +
      intprntvals[thrd][1] + " " + intprntvals[thrd][2] + " " +
      intprntvals[thrd][3] + " " + intprntvals[thrd][4] +
      "\n   array bounds problem 1");
   }

   /* Check for differences.
   if (chkflag && thisidname.equals("kenpres") && dst == 2 &&
       (grph_label[idnmbrm1][node - 1].equals("SMNTORDG") ||
        grph_label[idnmbrm1][node - 1].equals("SMMPG"))) {
      for (k = 0; k < nmvals; ++k) {
         prob1 = condprb[idnmbrm1][node - 1][k]
                  [intprntvals[thrd][0] - 1][intprntvals[thrd][1] - 1]
                  [intprntvals[thrd][2] - 1][intprntvals[thrd][3] - 1]
                  [intprntvals[thrd][4] - 1][0][dstm1];
         prob2 = condprb[idnmbrm1][node - 1][k]
                  [intprntvals[thrd][0] - 1][intprntvals[thrd][1] - 1]
                  [intprntvals[thrd][2] - 1][intprntvals[thrd][3] - 1]
                  [intprntvals[4] - 1][0][0];
         probdiff = Math.abs(prob1 - prob2); 
         printf_("update: prnt1= " + intprntvals[thrd][0] + " prnt2= " +
            intprntvals[thrd][1] + " k= " + k + " probh= " +
	    fdble_(prob2, 5, 3) + " probc= " + fdble_(prob1, 5, 3));
      }
   }
   */

   unif = Rndm.rndm1_(thrd, 0);
   for (k = 1; k <= nmvals - 1; ++k) {
      if (unif < upper) {
         nodevals[thrd][0][node - 1] = (double) k;
         nodevals[thrd][1][node - 1] = (double) k;
         return 0;
      }
      upper += condprb[idnmbrm1][node - 1][k]
                [intprntvals[thrd][0] - 1][intprntvals[thrd][1] - 1]
                [intprntvals[thrd][2] - 1][intprntvals[thrd][3] - 1]
                [intprntvals[thrd][4] - 1][0][dstm1];
   }
   nodevals[thrd][0][node - 1] = (double) nmvals;
   nodevals[thrd][1][node - 1] = (double) nmvals;

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Logit")) {

   if (nmvals == 2) {

      // Binary logit model.  First, compute logit.

      explogit = Math.exp(complogit_(thrd, node, 1, prntvals));

      // Compute probability.

      prob = explogit / (1. + explogit);

      // Generate a realization.

      unif = Rndm.rndm1_(thrd, 0);
      if (unif < prob) {
         nodevals[thrd][0][node - 1] = 1.;
         nodevals[thrd][1][node - 1] = 1.;

      } else {
         nodevals[thrd][0][node - 1] = 2.;
         nodevals[thrd][1][node - 1] = 2.;
      }

   } else if (nmvals == 3) {

      /* Cumulative Logit model.  Convert to probabilities and simulate
	 a realization.  Currently, only nmvals = 3 is coded. */

      upper = Math.exp(complogit_(thrd, node, 1, prntvals));
      upper = upper / (1. + upper);

      unif = Rndm.rndm1_(thrd, 0);
      for (k = 1; k <= nmvals - 1; ++k) {
         if (unif < upper) {
            nodevals[thrd][0][node - 1] = (double) k;
            nodevals[thrd][1][node - 1] = (double) k;
            return 0;
         }
	 prob = Math.exp(complogit_(thrd, node, 2, prntvals));
	 prob = (prob - upper * (1. + prob)) / (1. + prob);
	 upper += prob;
      }
      nodevals[thrd][0][node - 1] = (double) nmvals;
      nodevals[thrd][1][node - 1] = (double) nmvals;

   } else {
      iderr_("update: nmvals= " + nmvals + " in cumulative logit");
   }

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Normal")) {

   // Normal distribution.

   mu = condprb[idnmbrm1][node - 1][0][intprntvals[thrd][0] - 1]
	    [intprntvals[thrd][1] - 1][intprntvals[thrd][2] - 1]
	    [intprntvals[thrd][3] - 1][intprntvals[thrd][4] - 1]
	    [0][dstm1];

   sigma2 = condprb[idnmbrm1][node - 1][1][intprntvals[thrd][0] - 1]
	        [intprntvals[thrd][1] - 1][intprntvals[thrd][2] - 1]
	        [intprntvals[thrd][3] - 1][intprntvals[thrd][4] - 1]
		[0][dstm1];

   nodevals[thrd][1][node - 1] =
      mu + Math.sqrt(sigma2) * Rndm.stdnrm_(thrd);

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Lognormal")) {

   /* node is a lognormally distributed.  If Y is Lognormal(mu, sigma^2),
      then log(Y) is Normal(mu, sigma^2).  Let Parent 1's value be p1 and
      parent 2's value be p2.
      Then mu_l = condprb[idnmbrm1][node - 1][0][p1 - 1][[p2 - 1]... and
      sigma^2 = condprb[idnmbrm1][node - 1][1][p1 - 1][[p2 - 1]... .

      E(Y) = mu_l = exp(mu + .5 * sigma^2) and
      Var(Y) = sigma_L^2 = exp(2 * mu + 2 * sigma^2) - exp(2 * mu + sigma^2).
      Hence, mu = log(mu_l) - .5 * sigma^2.
   */

   mu_l = condprb[idnmbrm1][node - 1][0][intprntvals[thrd][0] - 1]
             [intprntvals[thrd][1] - 1][intprntvals[thrd][2] - 1]
	     [intprntvals[thrd][3] - 1][intprntvals[thrd][4] - 1]
	     [0][dstm1];

   sigma2 = condprb[idnmbrm1][node - 1][1][intprntvals[thrd][0] - 1]
	       [intprntvals[thrd][1] - 1][intprntvals[thrd][2] - 1]
	       [intprntvals[thrd][3] - 1][intprntvals[thrd][4] - 1]
	       [0][dstm1];

   nodevals[thrd][1][node - 1] = Math.exp((Math.log(mu_l) -
     .5 * sigma2) + Math.sqrt(sigma2) * Rndm.stdnrm_(thrd));

} else if (varinfo_dist[idnmbrm1][node - 1].equals("Gamma")) {

   // Gamma distribution.

   alphag = condprb[idnmbrm1][node - 1][0][intprntvals[thrd][0] - 1]
               [intprntvals[thrd][1] - 1][intprntvals[thrd][2] - 1]
	       [intprntvals[thrd][3] - 1][intprntvals[thrd][4] - 1]
	       [0][dstm1];

   betag = condprb[idnmbrm1][node - 1][1][intprntvals[thrd][0] - 1]
              [intprntvals[thrd][1] - 1][intprntvals[thrd][2] - 1]
	      [intprntvals[thrd][3] - 1][intprntvals[thrd][4] - 1]
	      [0][dstm1];

   nodevals[thrd][1][node - 1] = Rndm.gamdev_(thrd, alphag, betag);

} else if (varinfo_dist[idnmbrm1][node - 1].equals("SDE") ||
           varinfo_dist[idnmbrm1][node - 1].equals("HIBM") ||
           varinfo_dist[idnmbrm1][node - 1].equals("PIBM") ||
           varinfo_dist[idnmbrm1][node - 1].equals("SMS") ||
           varinfo_dist[idnmbrm1][node - 1].equals("R_Horn_ABM") ||
           varinfo_dist[idnmbrm1][node - 1].equals("M_Network_ABM")) {

   /* Time-stepping functions.  Solve the system defined by all SDE,
      IBM, SMS, or ABM nodes in the model (a vector-valued SDE, IBM,
      SMS, or ABM).  Store the solution in "nodevals" and then just read
      these values out as the "node" counter cycles through these nodes.

      The parameters of these nodes are stored in "condprb[]..."
      and each such node has its number of values
      (nodenghs[idnmbrm1][node - 1][0])
      set to the number of its parameters.  Hence, for each unique
      combination of the discrete parents, there is a new vector of 
      time-stepping functions.

      If this is the first component node in a system,
      compute one time step of the entire vector solution.  Otherwise,
      use the previously-computed values stored in "yn."
      
      An Individual Based Model (IBM), Stochastic Movement Simulator (SMS),
      or Agent Based Model (ABM) node needs the same processing within
      an ID as an SDE.  IBMs, SMSs, and ABMs can be vector-valued also,
      e.g. a predator-prey model. */

   /*
   if (thisidname.equals("cheetaheco") && thrd == 1 && node == 10) {
      printf_("update: tmefcnstep= " + tmefcnstep[thrd] +
         " idenom= " + idenom[thrd]);
   }
   */

   if (tmefcnstep[thrd]) {
      if (varinfo_dist[idnmbrm1][node - 1].equals("SDE")) {
         SDEcalcs.sdesol_(thrd, nodevals, fixedvars, yn, dst);

      } else if (varinfo_dist[idnmbrm1][node - 1].equals("HIBM")) {
         HIBMcalcs.step_(thrd, nodevals, yn, dst);

      } else if (varinfo_dist[idnmbrm1][node - 1].equals("PIBM")) {
         PIBMcalcs.step_(thrd, nodevals, yn, dst);

      } else if (varinfo_dist[idnmbrm1][node - 1].equals("SMS")) {
         SMScalcs.simpaths_(thrd, nodevals, yn, dst);

      } else if (varinfo_dist[idnmbrm1][node - 1].equals("R_Horn_ABM")) {
         Econcalcs.step_(thrd, nodevals, yn, dst);
      
      } else if (varinfo_dist[idnmbrm1][node - 1].equals("M_Network_ABM")) {
         Mfgnetwork.step_(thrd, nodevals, yn, dst);
      }

      // Load the solution into the corresponding ID state location.

      for (j = 0; j < nmtmefcns[idnmbrm1]; ++j) {
         if (!fixedvars[idnmbrm1][j]) {
	    nodevals[thrd][1][tmefcnnm[idnmbrm1][j] - 1] = yn[thrd][j];
	 }
         
         /*
         if (thrd == 1 && dst == 1) {
	    printf_("update: dst= " + dst + " node= " +
               tmefcnnm[idnmbrm1][j] +
	       " beltmept= " + beltmept[thrd] + " j= " + j +
	       " yn= " + yn[thrd][j]);
	 }
	 if (thrd == 1 && grph_label[idnmbrm1]
            [tmefcnnm[idnmbrm1][j] - 1].equals("IllegalPrice")) {
             printf_("update: illegal price= " +
                nodevals[thrd][1][tmefcnnm[idnmbrm1][j] - 1]);
         }
         */
      }

      /* Stop evaluating time-stepping functions if this is an "evaluate"
         run (!loadconsdst) or the end of a CA run
         (loadconsdst && dst == 2).

      if (!loadconsdst || (loadconsdst && dst == 2)) {
         tmefcnstep[thrd] = false;
      }
      */

   } // End of tmefcnstep condition.

   // Update time-stepping function counter.

   ++tmefcncounter[thrd][dstm1];
   if (tmefcncounter[thrd][dstm1] == nmtmefcns[idnmbrm1]) {
      tmefcncounter[thrd][dstm1] = 0;
      if (!loadconsdst || (loadconsdst && dst == 2)) {
	 tmefcnstep[thrd] = true;
      }
   }
} // End of time-stepping functions condition.

// Place solution at time t into solution at time t-1.

nodevals[thrd][0][node - 1] = nodevals[thrd][1][node - 1];

return 0;
}

// ----------------------------------------------------------------

public static double complogit_(int thrd, int node, int val,
   double prntvals[][]) {

// Computes the logit for node value, "val."

String parent;

int i, j, start = 0, nmprnts, prntnm = 0, nmprntvals = 0;

double logit = 0.;

nmprnts = nodenghs[idnmbrm1][node - 1][1];
if (!varinfo_dist[idnmbrm1][node - 1].equals("Logit")) {
   iderr_("complogit: node is not a Logit distribution.");
}

// Cumulative logit, main effects only.

logit = logit_pars[idnmbrm1][node - 1][val - 1];

if (nmvals == 2) {
   start = 0;

} else {
   start = 1;
}

for (i = 0; i < nmprnts; ++i) {
   prntnm = nodenghs[idnmbrm1][node - 1][i + 2];
   nmprntvals = nodenghs[idnmbrm1][prntnm - 1][0];
   logit += complogitpar_(node, prntvals[thrd][i], nmprntvals, start);
   start += nmprntvals - 1;
}
return logit;
}

// ----------------------------------------------------------------------

public static double complogitpar_(int node, double prntval, int nmprntvals,
   int start) {

/* Computes the value of a logit term for a discrete or continuous
   predictor node. */

int j;
double sum = 0., parval = 0.;

if (nmprntvals > 1) {

   // Discrete predictor.

   if (prntval < nmprntvals) {
      parval = logit_pars[idnmbrm1][node - 1][start + ((int) prntval)];

   } else {
      for (j = 0; j < nmprntvals - 1; ++j) {
         sum += logit_pars[idnmbrm1][node - 1][start + j];
      }
      parval = -sum;
   }

} else {

   // Continuous predictor.

   parval = logit_pars[idnmbrm1][node - 1][start + 1] * prntval;
}
return parval;
}
}
