class Vargrm extends Surf {

static boolean produceplot = true;

static String vnames[] = new String[NUMMDLS];

// ----------------------------------------------------------------------

static int vargrm_(int mode, boolean start, double xcord, double ycord,
   double tmecord, double a[], double g[], double h[]) {
 
/* Generates the values of the experimental semi-variogram developed from
   the subroutine ``gama3'' in Journel, "Mining Geostatistics".
 
   Options are:
     1) Anisotropic variograms
     2) Cross co-variograms
     3) Transformation of data (log)

   Values of mode:
      1: Kriging initialization, just read in parameters and data;
      2: Optimization mode, no printing or plotting;
 
   The dimensions of gama.g (semivariogram) are
   [lag][direction][time][variable].
   The third variable is the cross-variogram. */

boolean test = false;

int i, ii, j, k, retval = 0, tlags;

String psfle;

String datfle[] = new String[2];

// For mode = 1, read parameters.

if (mode == 1) {

   // Defaults.

   ndi = 1;
   if (ndi > 2) iderr_("ndi too big in vargrm");
   da = 90.0;
   pas = 1.0;
   tol = 0.5;
   if (kmaxt == 0) {
      past = 1.;
   
   } else {
      retval = (int) ((spacetime_tmax - spacetime_tmin) /
		      ((double) kmaxt));
      past = (double) retval;
      if (icrval == 1) {
         past = 1.;
      }
   }
   tolt = .001;
   alp[0] = 0.0;
   alp[1] = 90.0;

   /* Figure out how many covariogram models there are and create the
      map from variable number to covariogram number.  Also, specify
      cross-covariogram models.  The direct-covariogram models were read
      from the .par file, see Surf.java.  The covariogram models in
      Covmodl.java  are:
      0: nugget-only, direct- or symmetric cross-covariogram
      1: spherical,   direct- or symmetric cross-covariogram
      2: exponential, direct- or symmetric cross-covariogram
      3: asymmetric, damped, sinusoidal cross-covariogram
      5: wave. */

   nmmdls = parm_mvar + parm_mvar * (parm_mvar - 1) / 2;
   if (nmmdls > NUMMDLS) {
      iderr_("vargrm: nmmdls too big");
   }

   for (i = 0; i < parm_mvar; ++i) {
      vnames[i] = "    " + nodelbls[idnmbrm1][lomapnms[i] - 1][0] + "    ";
   }
   k = parm_mvar + 1;
   for (i = 0; i < parm_mvar; ++i) {
      for (j = 0; j < i; ++j) {

         /* For furs data set, cross is asymmetric, otherwise, cross is
            spherical.
         if (nmobs[idnmbrm1][lomapnms[0] - 1] == 62) {
	    varmod_model[k - 1] = 3;
         */

	 if (parm_mvar > 4) {
	    varmod_model[k - 1] = 0;
         
	 } else {
	    varmod_model[k - 1] = 1;
         }

         vnames[k - 1] = nodelbls[idnmbrm1][lomapnms[i] - 1][0] + "_vs_" +
                  nodelbls[idnmbrm1][lomapnms[j] - 1][0];
         ++k;
      }
   }

   if (varmod_model[parm_mvar] == 3 && spatial && temporal) {
      iderr_("asymmetric s-t cross-covariogram not ready");
   }

   // Write header and echo input.

   fprintf_(1, 
      "\n------------------- VARIOGRAM OPTIONS ------------------" +
      "\nno. of lags        = " + kmax +
      "\nno. of directions  = " + ndi +
      "\nno. of variables   = " + parm_mvar +
      "\nangle tolerance    = " + da +
      "\nlag length         = " + pas +
      "\nDistance epsilon   = " + varmod_epsln +
      "\ndistance tolerance = " + tol);
   for (i = 0; i < ndi; ++i) {
      fprintf_(1, "direction angle " + (i + 1) + "= " + alp[i]);
   }
   strng = "\nVariogram models: 1=spherical, 2=exponential, 3=gaussian,";
   strng += " 4=wave.";
   fprintf_(1, strng);
   for (i = 0; i < parm_mvar; ++i) {
      fprintf_(1, "Variable " + (i + 1) + " variogram model= " +
         varmod_model[i]);
   }
   if (parm_mvar > 1) {
      fprintf_(1, "Cross model= " + varmod_model[2]);
   }
   if (temporal) {
      fprintf_(1, "Number of time lags= " + kmaxt +
         "\nTime lag length    = " + past +
         "\nTime lag tolerance = " + tolt);
   }

   // Return from this initialization call.

   return 0; 
}

/* Compute spatial and temporal lags, First spatial lag is 1/4 of the
   basic lag.  First temporal lag is zero.  From these, compute the
   Zhang et al. variogram fitting weights. */

lags[0] = .25 * pas;
for (i = 1; i <= kmax; ++i) {
   lags[i] = pas * (double) (i);
}
for (i = 0; i <= kmaxt; ++i) {
   lagt[0][i] = past * (double) i; 
}
for (i = 0; i <= 2 * kmaxt; ++i) {
   lagt[1][i] = (past * (double) i) - lagt[0][kmaxt];
}

// Call gama3 and stop if zero variance is detected.

retval = Gama3.gama3_(ndi, alp, da, mode, tolt, test, start); 
if (retval == 1) {
   varmod_ifail = 5;
   printf_("vargrm: zero variance from gama3");
   return 0;
}

/* Fit a model to the sample semi-variograms using nonlinear regression.
   First, compute modified Zhang et al. (1995) weights for the least
   squares objective function. */

for (ii = 0; ii < nmmdls; ++ii) {
   if (temporal) {
      if (ii < parm_mvar) {
	 tlags = kmaxt;
      
      } else {
	 tlags = 2 * kmaxt;
      }

   } else {
      tlags = 0;
   }
   for (i = 0; i <= kmax; ++i) {
      for (k = 0; k <= tlags; ++k) {
         wght[ii][i][k] = gama_nc[i][0][k][ii] /
		          (varmod_avegam2[ii] + 1.);
         // wght[ii][i][k] = 1. / varmod_avegam2[ii];

         if (spatial && !temporal) {

            // Spatial-only case.

            if (lags[i] > 0.) {
	       wght[ii][i][k] /= lags[i] * lags[i];
            }

         } else if (!spatial && temporal) {

            // Temporal-only case.

	    if (ii < parm_mvar) {
	       if (lagt[0][k] > 0.) {
		  wght[ii][i][k] /= lagt[0][k] * lagt[0][k];
               }

	    } else {
	       if (lagt[1][k] > 0.) {
	          wght[ii][i][k] /= lagt[1][k] * lagt[1][k];
	       }
	    }

         } else if (spatial && temporal) {

            // Spatio-temporal case.

	    wght[ii][i][k] /= Math.max(lags[i] / (lags[kmax] + 1.),
	                        lagt[0][k] / (lagt[0][kmaxt] + 1.));
         }
      }
   }
}

// Call the nonlinear, constrained optimization routine.

varmod_ifail = varfit_(mode, start, xcord, ycord, tmecord, a, g, h);

// Write solution if found, otherwise so state.

if (mode == 1 || test) {
   fprintf_(1, "ifail= " + varmod_ifail);
   if (varmod_ifail == 1) {
      fprintf_(1, "Weighted least squares failed to converge in vargrm_.");

   } else if (varmod_ifail == 2) {
      fprintf_(1, "nugget < 0, reset to 0 in vargrm_().");
   }
}

return 0;
}

// ---------------------------------------------------------------------

static int varfit_(int mode, boolean start, double xcord,
   double ycord, double tmecord, double a[], double g[], double h[]) {

/* Fits the semivariogram or, covariogram function matrix if parm_mvar > 1.
   mode = 2 means no printed output (optimization mode).  k is the
   covariogram number. */

boolean test = false, ifail = false;

int i, j, nmimp = 0, cntr;

double intchi, chisq;

// Zero-out all covariogram matrix parameters.

for (cntr = 0; cntr <= nmstmixcntr; ++cntr) {
   for (i = 0; i < nmmdls; ++i) {
      varmod_nugget[cntr][i] = 0.;
      varmod_sill[cntr][i] = 0.;
      for (j = 0; j < 2; ++j) {
         varmod_range[cntr][j][i] = 0.;
      }
      varmod_oddnug[cntr][i] = 0.;
      varmod_oddsill[cntr][i] = 0.;
      varmod_oddrnge[cntr][i] = 0.;
   }
}

// Define initial parameter vector.

Loadpar.loadpar_(1, 0, a, g, h);

if (parm_mvar > 1) {

   // Check for and, if needed, fix an invalid set of nugget parameters.

   Optimiz.cnstrnt[0] = Optf.nuggcnstrnt_();
   if (test) {
      printf_("varfit: c0 before fit= " + Optimiz.cnstrnt[0]);
   }

   if (Optimiz.cnstrnt[0] < 0.) {
      for (i = parm_mvar; i < nmmdls; ++i) {
	 varmod_nugget[0][i] = 0.;
      }
      Loadpar.loadpar_(5, 0, a, g, h);
   }

   // Check for and, if needed, fix an invalid set of sill parameters.

   Optimiz.cnstrnt[1] = Optf.speccnstrnt_();
   if (test) {
      printf_("varfit: c1 before fix= " + Optimiz.cnstrnt[1]);
   }

   if (Optimiz.cnstrnt[1] < 0.) {
      for (i = parm_mvar; i < nmmdls; ++i) {
	 varmod_sill[0][i] = 0.;
      }
      Loadpar.loadpar_(5, 0, a, g, h);
   }
   if (test) {
      printf_("varfit: c1 after fix= " + Optimiz.cnstrnt[1]);
   }
}

if (test) {
   printf_("\nvarfit: Initial values before optimization:");
   Covmodl.covprt_(0);
   Covmodl.covprt_(1);
}

// Compute initial sum of squares.

intchi = Optf.optf_(false, varmod_nmpars, a, g, h);
if (test) {
   printf_("varfit: Starting values: cnstrnt1= " + Optimiz.cnstrnt[0] +
      " cnstrnt2= " + Optimiz.cnstrnt[1] +
      "\n          intchi= " + intchi);
   // iderr_("in varfit");
}

// Declare all optimization variables to be continuously-valued.

for (i = 0; i < varmod_nmpars; ++i) {
   Pxp.vartype[i] = "Determ_Contin";
}

/* Specify number of local covariogram matrix constraints and perform
   minimization.  For a multivariate model, there is only one implicit
   constraint (the nugget constraint, see "optf_") because the
   continuous covariogram constraint (the spectral constraint) is
   represented as a penalty function in "optf_." */

if (parm_mvar > 1) {
   nmimp = 1;
   Optimiz.gimplicit[0] = 0.;
   Optimiz.himplicit[0] = 1.e10;
}

Optf.maxchisq = 1.;
Optf.maxcnstrnt2 = 1.;
Optimiz.optimiz_(varmod_nmpars, nmimp, a, g, h, 1);

// A test should occur here to check if the optimization failed.

ifail = false;

if (ifail && test) {
   fprintf_(1,  "varfit: grow= " + grow + " gcol= " + gcol +
      " xcord= " + xcord + " ycord= " + ycord);
   iderr_("varfit: minimization routine failed");
}

// Replace any zero variance model with the sample variance.

for (i = 0; i < parm_mvar; ++i) {
   if (varmod_nugget[0][i] + varmod_sill[0][i] < 1.e-10) {
      fprintf_(1, "LOMAP variable " + i + " has zero variance, replacing" +
         " with smplvr= " + varmod_smplvr[i]);
      varmod_nugget[0][i] = varmod_smplvr[i];
      varmod_sill[0][i] = 0.;
   }
}

/* Determine if the fitting algorithm has failed.  First compute the
   objective function and any constraints.  Check positive definiteness
   two ways and stop if either is violated. */

chisq = Optf.optf_(false, varmod_nmpars, a, g, h);
if (parm_mvar > 1) {

   // Check for and, if needed, fix an invalid set of nugget parameters.

   Optimiz.cnstrnt[0] = Optf.nuggcnstrnt_();
   if (test) {
      printf_("varfit: c0 after fit= " + Optimiz.cnstrnt[0]);
   }

   if (Optimiz.cnstrnt[0] < 0.) {
      for (i = parm_mvar; i < nmmdls; ++i) {
	 varmod_nugget[0][i] = 0.;
      }
      Loadpar.loadpar_(5, 0, a, g, h);
   }

   // Check for and, if needed, fix an invalid set of sill parameters.

   Optimiz.cnstrnt[1] = Optf.speccnstrnt_();
   if (test) {
      printf_("varfit: c1 after fit= " + Optimiz.cnstrnt[1]);
   }

   if (Optimiz.cnstrnt[1] < 0.) {
      for (i = parm_mvar; i < nmmdls; ++i) {
	 varmod_sill[0][i] = 0.;
      }
      Loadpar.loadpar_(5, 0, a, g, h);
   }
   if (test) {
      printf_("varfit: c1 after fix= " + Optimiz.cnstrnt[1]);
   }

   // Cholesky decomposition check.

   Optimiz.cnstrnt[1] = Optf.chkcovdat_(false, true, "varfit");
   if (Optimiz.cnstrnt[1] < 0.) {
      prntcovmdl_(0); 
      iderr_("varfit: chkcovdat failure, ifail= " + ifail +
         " cnstrnt1= " + Optimiz.cnstrnt[0] + " cnstrnt2= " +
	 Optimiz.cnstrnt[1]);
   }
}

// If the optimization failed, update parameter estimates as required.

if (ifail && parm_mvar == 1) {
   if (test) {
      fprintf_(1, "Initial SS < Final SS, so using initial values...");
   }
   Loadpar.loadpar_(2, 0, a, g, h);
}

// If full mode reporting, write starting values and best chisq to output.
 
if (mode == 1 || test) {
   printf_("varfit: ifail= " + ifail + " initial SS= " + intchi +
      "\n   final SS= " + chisq + " fnlSS/intlSS= " + (chisq / intchi));
   if (parm_mvar > 1) {
      fprintf_(1, "varfit: cnstrnt1= " + Optimiz.cnstrnt[0] +
	 " constrnt2= " + Optimiz.cnstrnt[1] +
	 "\n   chisqd= " + chisqd + " chisqc= " + chisqc + 
         "\n   fraction cross= " + (chisqc / (chisqc + chisqd)));
   }
   Covmodl.covprt_(1);
}

// To plot just on covariance structure.

if (!produceplot &&
    varmod_nugget[0][0] < .9 * varmod_sill[0][0] &&
    varmod_nugget[0][1] < .9 * varmod_sill[0][1] &&
    varmod_nugget[0][2] < .9 * varmod_sill[0][2]) {
   Covmodl.covprt_(1);
   produceplot = true;
}

return (ifail) ? 1 : 0;
}

// ---------------------------------------------------------------------

static void prntcovmdl_(int cntr) {

// Print covariogram model.

int i, j, cvstrct;

fprintf_(1, "\n ********  Vargrm covariogram models for cntr= " + cntr);
fprintf_(1, "----- Direct-Covariograms -----");
fprintf_(1, " Variable  Nugget   Sill   Spatial Range   Temporal Range");
for (j = 0; j < parm_mvar; ++j) {
   if (spatial) {
      fprintf_(1, lomapnms[j] + "     " +
         fdble_(varmod_nugget[cntr][j], 9, 5) + "   " +
         fdble_(varmod_sill[cntr][j], 9, 5) + "   " +
         fdble_(varmod_range[cntr][0][j], 9, 5) + "   " +
         fdble_(varmod_range[cntr][1][j], 9, 5));

   } else {
      fprintf_(1, lomapnms[j] + "     " +
         fdble_(varmod_nugget[cntr][j], 9, 5) + "   " +
         fdble_(varmod_sill[cntr][j], 9, 5) + "   " +
         fdble_(varmod_range[cntr][0][j], 9, 5) + "   " +
         fdble_(varmod_range[cntr][1][j], 9, 5));
   }
   if (lngmem) {
      fprintf_(1, "   Long memory: lma= " + fdble_(varmod_lma[j], 9, 5) +
         " lmb= " + fdble_(varmod_lmb[j], 9, 5) +
         " lmc= " + fdble_(varmod_lmc[j], 9, 5));
   }
}

// Print covariance nonstationarity parameters if any.

if (covnonstatmdl == 1) {
   fprintf_(1, "nonstat1= " + varmod_nonstat[0] + " nonstat2= " +
      varmod_nonstat[1] + " nonstat3= " + varmod_nonstat[2]);
}

if (parm_mvar == 1) return;

fprintf_(1, "----- Cross-Covariograms, cntr= " + cntr + " -----");
fprintf_(1,
   " Variable_1 Variable_2  Nugget   Sill   Spatial Range   Temporal Range");
for (i = 1; i < parm_mvar; ++i) {
   for (j = 0; j < i; ++j) {
      cvstrct = crossmap[i][j];
      if (spatial) {
         fprintf_(1, "     " + lomapnms[i] + "        " +
            lomapnms[j] + "     " +
            fdble_(varmod_nugget[cntr][cvstrct - 1], 9, 5) + "   " +
            fdble_(varmod_sill[cntr][cvstrct - 1], 9, 5) + "   " +
            fdble_(varmod_range[cntr][0][cvstrct - 1], 9, 5) + "   " +
            fdble_(varmod_range[cntr][1][cvstrct - 1], 9, 5));

      } else {
         fprintf_(1, "     " + lomapnms[i] + "      " + lomapnms[j] +
            "       " +
            fdble_(varmod_nugget[cntr][cvstrct - 1], 9, 5) + "    " +
            fdble_(varmod_sill[cntr][cvstrct - 1], 9, 5) + "    " +
            fdble_(varmod_range[cntr][0][cvstrct - 1], 9, 5) + "    " +
            fdble_(varmod_range[cntr][1][cvstrct - 1], 9, 5));
      }
      if (varmod_model[cvstrct - 1] == 3) {
         fprintf_(1, "Odd:                " +
            fdble_(varmod_oddnug[cntr][cvstrct - 1], 9, 5) + "    " +
            fdble_(varmod_oddsill[cntr][cvstrct - 1], 9, 5) +
            "                 " +
            fdble_(varmod_oddrnge[cntr][cvstrct - 1], 9, 5));
      }
   }
}
}
}
