import java.rmi.RemoteException;
import net.jini.core.entry.*;
import net.jini.core.lease.Lease;
import net.jini.core.transaction.*;
import net.jini.space.JavaSpace;

public class Worker {
JavaSpace space = null;
boolean offline = false;

public Worker() {

if (!offline) {
   // SpaceAccessor newSpaceAccessor = new SpaceAccessor();
   // space = newSpaceAccessor.getSpace();

   /* Start thread that will check for a "terminate" message posted to
      the space. */

   TermThread thrd = new TermThread();
   thrd.start();
}

}

// ---------------------------------------------------------------------

public static void dowork_(String idfle) {

// Start working.

Worker worker = new Worker();
worker.startWork(idfle);

}

// ---------------------------------------------------------------------

public void startWork(String idfle) {

// Do initial setup of problem before the task loop, below.

Id idobj = new Id();
idobj.id_(idfle, "worker", "none");
System.out.println("startWork: client initialization completed");

if (offline) {
   return;
}

// Task loop.  First, create a taskentry object.

TaskEntry taskTmpl = new TaskEntry();

while (true) {

   // Take a task from the space.

   // System.out.println("startWork: listening for a task...");
   try {
      TaskEntry task = (TaskEntry) 
         space.take(taskTmpl, null, Long.MAX_VALUE);

      if (task != null) {
         ResultEntry result = task.execute();
         if (result != null) {
            space.write(result, null, Lease.FOREVER);
         }

      } else {
	 System.out.println("startWork: task=null, trying again");
      }

   } catch (RemoteException e) {
      System.out.println("RemoteException:");
      System.out.println(e);
      Id.iderr_("Abnormal termination");

   } catch (TransactionException e) {
      System.out.println("TransactionException:");
      System.out.println(e);

   } catch (UnusableEntryException e) {
      System.out.println("UnusableEntryException:");
      System.out.println(e);

   } catch (InterruptedException ie) {
      System.out.println(ie);
      System.out.println("Space connection lost, terminating client.");
      System.exit(0);
   }
}
}

// ***********************************************************************

public class TermThread extends Thread {

// -----------------------------------------------------------------------

public void run() {

// Check for a "terminate" command in the space.

MsgEntry msgTmpl = new MsgEntry();
try {
   MsgEntry msg = (MsgEntry) space.read(msgTmpl, null, Long.MAX_VALUE);
   if (msg != null) {
      System.out.println("Normal termination of id client.");
      System.exit(0);
   }
} catch (RemoteException e) {
      System.out.println(e);
} catch (TransactionException e) {
      System.out.println(e);
} catch (UnusableEntryException e) {
      System.out.println(e);
} catch (InterruptedException e) {
      System.out.println("Task cancelled");
}
}
}
}
