class Writenet extends Readnet {
static int flenm = 6;

// ----------------------------------------------------------------------

static void writenet_(int source_dstnm, int storage_dstnm,
   boolean pflag) {

/* dstnm:   Distribution number:
	    1 is the hypothesis distribution,
	    2 is the initial solution, and
	    3 is the consistent distribution.

   The "source_dstnm" is written on the "storage_dstnm" file.
   Notes:
   1. The consistent distribution, 3 is stored in the 2nd
      position of "condprb."
   2. The initial solution is developed in the consistent distribution
      (2nd position of "condprb").
*/

int dstnm = 0, i, j1, j2, j3, j4, j5, j6, nmvals, nmnghs, dstctr;

if (source_dstnm < 3) {
   dstnm = source_dstnm;

} else if (source_dstnm == 3) {
   dstnm = 2;
}
fleopen_(flenm, dstfle[idnmbrm1][storage_dstnm - 1], 'w');

// Get the number of nodes.

nmnds = Intridslve.nmndes[idnmbrm1];

if (pflag) {
   printf_("writenet: writing distribution " + source_dstnm +
      " onto file " + dstfle[idnmbrm1][storage_dstnm - 1] + "...");
}

fprintf_(flenm, gphtitl[0]);
fprintf_(flenm, gphtitl[1]);

// Loop through nodes.

dstctr = 0;
for (i = 1; i <= nmnds; ++i){

   // Write node description information.

   if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Decision") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Determ_Root") ||
       varinfo_dist[idnmbrm1][i - 1].equals("Determ_Ratio")) {
      continue;

   } else if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete") ||
              varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete") ||
              varinfo_dist[idnmbrm1][i - 1].equals("Determ_Contin") ||
              varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {
      strng = "\nNode: " + grph_label[idnmbrm1][i - 1] + " Value_Labels:";
      nmvals = nodenghs[idnmbrm1][i - 1][0];
      for (j1 = 1; j1 <= nmvals; ++j1) {
         strng += " " + nodelbls[idnmbrm1][i - 1][j1];
      }

   } else {

      // Write parameter names and parameter bounds.

      strng = "\nNode: " + grph_label[idnmbrm1][i - 1] + " Parameters:";
      nmvals = varinfo_nmparms[idnmbrm1][i - 1];
      for (j1 = 0; j1 < nmvals; ++j1) {
         if (parmlbls[idnmbrm1][i - 1][j1] == null) {
            parmlbls[idnmbrm1][i - 1][j1] = "time" + (j1 + 1);
	 }
         strng += " " + parmlbls[idnmbrm1][i - 1][j1] + " (" +
            varinfo_bounds[idnmbrm1][i - 1][j1][0] + " " +
            varinfo_bounds[idnmbrm1][i - 1][j1][1] + ")";
      }
   }
   fprintf_(flenm, strng);

   nmnghs = nodenghs[idnmbrm1][i - 1][1];
   ngh1 = 1;
   ngh2 = 1;
   ngh3 = 1;
   ngh4 = 1;
   ngh5 = 1;

   if (varinfo_dist[idnmbrm1][i - 1].equals("Determ_Decision") &&
       nmnghs == 0) {
      continue;
   }

   if (nmnghs == 0) {
      ++dstctr;
      writeprb_(dstnm, i, 1, 1, 1, 1, 1, 1, nmvals, nmnghs);

   } else if (nmnghs == 1) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];

      if (varinfo_dist[idnmbrm1][i - 1].equals("Logit") &&
	  nmvalngh1 == 1) {
      
	 /* For a Logit node with a continuous predictor, write
            distributions for 3 values of the continuous predictor. */

	 nmvalngh1 = 3;
      }

      strng = "Parent: " + grph_label[idnmbrm1][ngh1 - 1];
      fprintf_(flenm, strng);
      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         ++dstctr;
         writeprb_(dstnm, i, j1, 1, 1, 1, 1, 1, nmvals, nmnghs);
      }

   } else if (nmnghs == 2) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      strng = "Parents: " + grph_label[idnmbrm1][ngh1 - 1] + " " +
         grph_label[idnmbrm1][ngh2 - 1];
      fprintf_(flenm, strng);
      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            ++dstctr;
            writeprb_(dstnm, i, j1, j2, 1, 1, 1, 1, nmvals, nmnghs);
	 }
      }

   } else if (nmnghs == 3) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      strng = "Parents: " + grph_label[idnmbrm1][ngh1 - 1] + " " +
         grph_label[idnmbrm1][ngh2 - 1] + " " +
	 grph_label[idnmbrm1][ngh3 - 1];
      fprintf_(flenm, strng);

      if (varinfo_dist[idnmbrm1][i - 1].equals("Logit") &&
	  nmvalngh2 == 1 && nmvalngh3 == 1) {
      
	 /* For a Logit node with continuous predictors for the last
	    two parents, write distributions for 3 values of each of
	    these continuous predictors. */

	 nmvalngh2 = 3;
	 nmvalngh3 = 3;
      }

      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1; j3 <= nmvalngh3; ++j3){
               ++dstctr;
               writeprb_(dstnm, i, j1, j2, j3, 1, 1, 1, nmvals, nmnghs);
            }
         }
      }

   } else if (nmnghs == 4) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      ngh4 = nodenghs[idnmbrm1][i - 1][5];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
      strng = "Parents: " + grph_label[idnmbrm1][ngh1 - 1] + " " +
         grph_label[idnmbrm1][ngh2 - 1] + " " +
	 grph_label[idnmbrm1][ngh3 - 1] + " " +
	 grph_label[idnmbrm1][ngh4 - 1];
      fprintf_(flenm, strng);

      if (varinfo_dist[idnmbrm1][i - 1].equals("Logit") &&
	  nmvalngh3 == 1 && nmvalngh4 == 1) {
      
	 /* For a Logit node with continuous predictors for the last
	    two parents, write distributions for 3 values of each of
	    these continuous predictors. */

	 nmvalngh3 = 3;
	 nmvalngh4 = 3;
      }

      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1; j3 <= nmvalngh3; ++j3){
               for (j4 = 1; j4 <= nmvalngh4; ++j4){
                  ++dstctr;
		  writeprb_(dstnm, i, j1, j2, j3, j4, 1, 1, nmvals, nmnghs);
               }
            }
         }
      }

   } else if (nmnghs == 5) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      ngh4 = nodenghs[idnmbrm1][i - 1][5];
      ngh5 = nodenghs[idnmbrm1][i - 1][6];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
      nmvalngh5 = nodenghs[idnmbrm1][ngh5 - 1][0];
      strng = "Parents: " + grph_label[idnmbrm1][ngh1 - 1] + " " +
         grph_label[idnmbrm1][ngh2 - 1] + " " +
	 grph_label[idnmbrm1][ngh3 - 1] + " " +
	 grph_label[idnmbrm1][ngh4 - 1] + " " +
	 grph_label[idnmbrm1][ngh5 - 1];
      fprintf_(flenm, strng);
      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1; j3 <= nmvalngh3; ++j3){
               for (j4 = 1; j4 <= nmvalngh4; ++j4){
                  for (j5 = 1; j5 <= nmvalngh5; ++j5) {
                     ++dstctr;
		     writeprb_(dstnm, i, j1, j2, j3, j4, j5, 1,
			       nmvals, nmnghs);
                  }
               }
            }
         }
      }

   } else if (nmnghs == 6) {
      ngh1 = nodenghs[idnmbrm1][i - 1][2];
      ngh2 = nodenghs[idnmbrm1][i - 1][3];
      ngh3 = nodenghs[idnmbrm1][i - 1][4];
      ngh4 = nodenghs[idnmbrm1][i - 1][5];
      ngh5 = nodenghs[idnmbrm1][i - 1][6];
      ngh6 = nodenghs[idnmbrm1][i - 1][7];
      nmvalngh1 = nodenghs[idnmbrm1][ngh1 - 1][0];
      nmvalngh2 = nodenghs[idnmbrm1][ngh2 - 1][0];
      nmvalngh3 = nodenghs[idnmbrm1][ngh3 - 1][0];
      nmvalngh4 = nodenghs[idnmbrm1][ngh4 - 1][0];
      nmvalngh5 = nodenghs[idnmbrm1][ngh5 - 1][0];
      nmvalngh6 = nodenghs[idnmbrm1][ngh6 - 1][0];
      strng = "Parents: " + grph_label[idnmbrm1][ngh1 - 1] + " " +
         grph_label[idnmbrm1][ngh2 - 1] + " " +
         grph_label[idnmbrm1][ngh3 - 1] + " " +
	 grph_label[idnmbrm1][ngh4 - 1] + " " +
         grph_label[idnmbrm1][ngh5 - 1] + " " +
	 grph_label[idnmbrm1][ngh6 - 1];
      fprintf_(flenm, strng);
      for (j1 = 1; j1 <= nmvalngh1; ++j1){
         for (j2 = 1; j2 <= nmvalngh2; ++j2){
            for (j3 = 1; j3 <= nmvalngh3; ++j3){
               for (j4 = 1; j4 <= nmvalngh4; ++j4){
                  for (j5 = 1; j5 <= nmvalngh5; ++j5) {
                     for (j6 = 1; j6 <= nmvalngh6; ++j6) {
                        ++dstctr;
		        writeprb_(dstnm, i, j1, j2, j3, j4, j5, j6,
			          nmvals, nmnghs);
		     }
                  }
               }
            }
         }
      }
   }

   if (varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

      // Write logit parameters beneath the conditional probabilities.

      for (j1 = 0; j1 < varinfo_nmparms[idnmbrm1][i - 1]; ++j1) {
         fprintf_(flenm, parmlbls[idnmbrm1][i - 1][j1] + " " +
	    fdble_(logit_pars[idnmbrm1][i - 1][j1], 4, 2));
      }
   }
}

if (pflag) {
   printf_("writenet: *** Number of Distributions: " + dstctr + "***");
}

fclose_(flenm, 'w');
}

//--------------------------------------------------------------------

static void writeprb_(int dstnm, int i, int j1, int j2, int j3, int j4,
   int j5, int j6, int nmvals, int nmnghs) {

boolean test = false;

String space;

short k;

int l, slngth;

// Load parent value labels into "strng."

if (nmnghs == 0) {
   strng = " ";

} else if (nmnghs == 1) {

   if (nodenghs[idnmbrm1][ngh1 - 1][0] == 1 &&
       varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

      /* For a Logit node with a single, continuous predictor, get and
         write the 3 predictor values to be used in the logit model
	 approximation algorithm. */

      strng = fdble_(Fitlogit.continvals[ngh1 - 1][j1 - 1], 5, 2);

   } else {
      strng = nodelbls[idnmbrm1][ngh1 - 1][j1];
   }

} else if (nmnghs == 2) {
   strng = nodelbls[idnmbrm1][ngh1 - 1][j1] + " " +
      nodelbls[idnmbrm1][ngh2 - 1][j2];

} else if (nmnghs == 3) {
   if (nodenghs[idnmbrm1][ngh2 - 1][0] == 1 &&
       nodenghs[idnmbrm1][ngh3 - 1][0] == 1 &&
       varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

      /* For a Logit node with a continuous predictors for its last
	 two parents, get and write the 3 predictor values on each of
	 these predictors so that they can be used in the logit model
	 approximation algorithm. */

      strng = nodelbls[idnmbrm1][ngh1 - 1][j1] + " " +
         fdble_(Fitlogit.continvals[ngh2 - 1][j2 - 1], 5, 2) + " " +
         fdble_(Fitlogit.continvals[ngh3 - 1][j3 - 1], 5, 2);

   } else {
      strng = nodelbls[idnmbrm1][ngh1 - 1][j1] + " " +
         nodelbls[idnmbrm1][ngh2 - 1][j2] + " " +
         nodelbls[idnmbrm1][ngh3 - 1][j3];
   }

} else if (nmnghs == 4) {
   if (nodenghs[idnmbrm1][ngh3 - 1][0] == 1 &&
       nodenghs[idnmbrm1][ngh4 - 1][0] == 1 &&
       varinfo_dist[idnmbrm1][i - 1].equals("Logit")) {

      /* For a Logit node with a continuous predictors for its last
	 two parents, get and write the 3 predictor values on each of
	 these predictors so that they can be used in the logit model
	 approximation algorithm. */

      strng = nodelbls[idnmbrm1][ngh1 - 1][j1] + " " +
         nodelbls[idnmbrm1][ngh2 - 1][j2] + " " +
         fdble_(Fitlogit.continvals[ngh3 - 1][j3 - 1], 5, 2) + " " +
         fdble_(Fitlogit.continvals[ngh4 - 1][j4 - 1], 5, 2);

   } else {
      strng = nodelbls[idnmbrm1][ngh1 - 1][j1] + " " +
         nodelbls[idnmbrm1][ngh2 - 1][j2] + " " +
         nodelbls[idnmbrm1][ngh3 - 1][j3] + " " +
         nodelbls[idnmbrm1][ngh4 - 1][j4];
   }

} else if (nmnghs == 5) {
   strng = nodelbls[idnmbrm1][ngh1 - 1][j1] + " " +
      nodelbls[idnmbrm1][ngh2 - 1][j2] + " " + 
      nodelbls[idnmbrm1][ngh3 - 1][j3] + " " +
      nodelbls[idnmbrm1][ngh4 - 1][j4] + " " +
      nodelbls[idnmbrm1][ngh5 - 1][j5];

} else if (nmnghs == 6) {
   strng = nodelbls[idnmbrm1][ngh1 - 1][j1] + " " +
      nodelbls[idnmbrm1][ngh2 - 1][j2] + " " +
      nodelbls[idnmbrm1][ngh3 - 1][j3] + " " +
      nodelbls[idnmbrm1][ngh4 - 1][j4] + " " +
      nodelbls[idnmbrm1][ngh5 - 1][j5] + " " +
      nodelbls[idnmbrm1][ngh6 - 1][j6];
}

// Create space.

slngth = 50 - strng.length();
space = " ";
if (slngth > 1) {
   for (l = 0; l < slngth; ++l) {
      space += " ";
   }
}
strng = space + strng;

// Load and print parameter values for this set of conditioning values.

if (varinfo_dist[idnmbrm1][i - 1].equals("Discrete-Beta")) {
   strng += " " + 
      betaprb[i - 1][0][j1 - 1][j2 - 1][j3 - 1][j4 - 1][j5 - 1][j6 - 1]
	     [dstnm - 1] + " " + 
      betaprb[i - 1][1][j1 - 1][j2 - 1][j3 - 1][j4 - 1][j5 - 1][j6 - 1]
	     [dstnm - 1];

} else {
   for (k = 1; k <= nmvals; ++k) {
      if (k == nmvals && 
          (varinfo_dist[idnmbrm1][i - 1].equals("Discrete") ||
           varinfo_dist[idnmbrm1][i - 1].equals("Logit"))) {
         break;
      }

      if (k > 1 &&
	  varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete")) {
	 break;
      }

      if (test) {
         printf_("writeprb: node= " + nodelbls[idnmbrm1][i - 1][0] +
            "\n   i= " + i + " k= " + k + " j1= " + j1 +
            " j2= " + j2 + " j3= " + j3 + " j4= " + j4 + " j5= " +
            j5 + " j6= " + j6 + " dstnm= " + dstnm +
	    "\n   strng= " + strng +
            "\n   condprb= " +  condprb[idnmbrm1][i - 1][k - 1][j1 - 1]
                                       [j2 - 1][j3 - 1][j4 - 1][j5 - 1]
				       [j6 - 1][dstnm - 1]);
      }

      if (!varinfo_dist[idnmbrm1][i - 1].equals("Determ_Discrete")) {
         strng += "  " + fdble_(condprb[idnmbrm1][i - 1][k - 1][j1 - 1]
                                       [j2 - 1][j3 - 1][j4 - 1][j5 - 1]
				       [j6 - 1][dstnm - 1],
                                5, 3);
      
      } else { 
         strng += "  " + fdble_(condprb[idnmbrm1][i - 1][k - 1][j1 - 1]
                                       [j2 - 1][j3 - 1][j4 - 1][j5 - 1]
				       [j6 - 1][dstnm - 1],
                                3, 1);
      }
   }
}

fprintf_(flenm, strng);

}

// ----------------------------------------------------------------------

static void wrtedsts_() {

String savename = "none";

int i;

if (nmids == 1) {
   idnmbrm1 = 0;
   writenet_(3, 3, false);

} else {

   // Loop through IDs.

   for (i = 0; i < nmids; ++i) {
      thisidname = idname[i];
      idnmbrm1 = i;

      // Write this ID's consistent parameter (.par) file.

      writenet_(3, 3, false);
   }
}
}
}
