import java.rmi.*;
import net.jini.space.JavaSpace;
import com.sun.jini.mahout.binder.RefHolder;
import com.sun.jini.mahout.Locator;
import com.sun.jini.outrigger.Finder;

public class SpaceAccessor {
    public static JavaSpace getSpace(String name) {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(
                    new RMISecurityManager());
            }
                      
            if (System.getProperty("com.sun.jini.use.registry") 
                == null) 
            {
                Locator locator =
                    new com.sun.jini.outrigger.DiscoveryLocator();
                Finder finder =
                    new com.sun.jini.outrigger.LookupFinder();
                return (JavaSpace)finder.find(locator, name);
            } else {
                RefHolder rh = (RefHolder)Naming.lookup(name);
                return (JavaSpace)rh.proxy();
            }
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }
    
    public static JavaSpace getSpace() {
        return getSpace("JavaSpaces");
    }
}
