static void betweencent_(int nmnodes, int nmlinks, int link[][],
   double centval[]) {

// Computes each node's betweeness centrality value.

int i, j, k;

double scale;

scale = (double) nmnodes;
scale = (scale - 1.) * (scale - 2.) / 2.;
for (i = 1; i <= nmnodes; ++i) {
   printf_("betweencent: Beginning node " + i);
   centval[i - 1] = 0.;
   for (j = 1; j <= nmnodes; ++j) {
      for (k = j + 1; k <= nmnodes; ++k) {
	 if (i == j || i == k) {
            continue;
	 }
         shortestpaths_(j, i, k, nmlinks, link, nmshrtstpths);
	 if (nmshrtstpths[0] > 0) {
            centval[i - 1] += ((double) nmshrtstpths[1]) /
		              ((double) nmshrtstpths[0]);
	 }
      }
   }
   centval[i - 1] /= scale;
   printf_("betweencent: node " + i + " bet.cent= " + centval[i - 1]);
}
}

// ------------------------------------------------------------------

static void shortestpaths_(int nodep, int nodei, int nodeq, int nmlinks,
   int link[][], int nmshrtstpths[]) {

/* Finds the number of shortest paths between "nodei" and "nodej" in the
   network defined by the links contained in "link."  Do this as follows.

   Grow paths one step at a time.  Do this by stepping each path forward
   one step by finding the node that is linked to each path's current
   endnode.  Find the next node in a path by reading the "link" array
   until the path's endnode is hit.  If an endnode has more than one
   link, start a new path for each of these additional links.
   Stop building a path when it either dead-ends or has "nodeq" as its
   endnode.

   If all paths have been updated on a step but links have not all been
   searched, start  new paths to receive the last of these links.  Each
   of these new paths is identical from nodei up to the end of the last
   step:
                                 ._.
                        nodei._./   \.nodej
                                \._./

   */

boolean foundpath = false, tookastep = false, foundbad = false;

int i, j, k, endnode = 0, pl = 0, nmpaths = 1, pathid = 0;

/*
nodep = 1;
nodei = 2;
nodeq = 5;
nmlinks = 7;
link[0][0] = 1;
link[0][1] = 2;
link[1][0] = 2;
link[1][1] = 3;
link[2][0] = 2;
link[2][1] = 7;
link[3][0] = 3;
link[3][1] = 4;
link[4][0] = 4;
link[4][1] = 5;
link[5][0] = 7;
link[5][1] = 6;
link[6][1] = 6;
link[6][0] = 5;
*/

// Initialize.

for (i = 0; i < TNMLINKS; ++i) {
   pathlength[i] = 0;
   for (j = 0; j < TNMNDS; ++j) {
      path[i][j] = 0;
   }
}

endnode = nodep;
path[0][0] = endnode;
do {
   tookastep = false;
   foundpath = false;
   for (i = 0; i < nmlinks; ++i) {
      if (!foundpath) {
         PATHS: for (j = 0; j < nmpaths; ++j) {
            pl = pathlength[j];

	    // Skip a completed path.

	    if (path[j][pl] == nodeq) {
               continue;
	    }

	    /* Check if either end of this link is already in the
	       path. */

	    for (k = 0; k < pathlength[j]; ++k) {
               if (path[j][k] == link[i][0] ||
                   path[j][k] == link[i][1]) {
                  continue PATHS;
	       }
	    }

	    if (path[j][pl] == link[i][0]) {
               endnode = link[i][0];
	       ++pl;
	       path[j][pl] = link[i][1];
	       pathlength[j] = pl;
	       pathid = j;
	       foundpath = true;
	       tookastep = true;
	       break;
	    
	    } else if (path[j][pl] == link[i][1]) {
               endnode = link[i][1];
	       ++pl;
	       path[j][pl] = link[i][0];
	       pathlength[j] = pl;
	       pathid = j;
	       foundpath = true;
	       tookastep = true;
	       break;
	    }
	 }
      
      } else {

	 /* As long as a path has been found on a previous link,
	    create new paths from this path. */

         if (endnode == link[i][0]) {
            pl = pathlength[pathid];
	    for (j = 0; j < pl; ++j) {
               path[nmpaths][j] = path[pathid][j];
	    }
	    path[nmpaths][pl] = link[i][1];
	    pathlength[nmpaths] = pl;
	    ++nmpaths;
	    tookastep = true;
	 
	 } else if (endnode == link[i][1]) {
            pl = pathlength[pathid];
	    for (j = 0; j < pl; ++j) {
               path[nmpaths][j] = path[pathid][j];
	    }
	    path[nmpaths][pl] = link[i][0];
	    pathlength[nmpaths] = pl;
	    ++nmpaths;
	    tookastep = true;
	 }
      }
   }
} while (tookastep);

/*
if (nodep == 1 && nodei == 4 && nodeq == 10) {
   for (i = 0; i < nmpaths; ++i) {
      for (j = 0; j <= pathlength[i]; ++j) {
         printf_("i= " + i + " node= " + playerid[path[i][j] - 1]);
      }
   }
}
*/

/* Find the number of shortest paths between "nodep" and "nodeq" and
   the number of these paths that contain "nodei." */

do {
   foundbad = false;
   for (i = 0; i < nmpaths; ++i) {
      if (path[i][pathlength[i]] != nodeq) {
	 foundbad = true;
	 for (j = i; j < nmpaths - 1; ++j) {
            pathlength[j] = pathlength[j + 1];
            for (k = 0; k <= pathlength[j + 1]; ++k) {
               path[j][k] = path[j + 1][k];
            }
	 }
         --nmpaths;
	 break;
      }
   }
} while (foundbad);

/*
if (nodep == 1 && nodei == 4 && nodeq == 10) {
   iderr_("nmpaths= " + nmpaths);
}
*/

for (i = 0; i < nmpaths; ++i) {
   containsnodei[i] = false;
   for (j = 1; j <= pathlength[i]; ++j) {
      if (path[i][j] == nodei) {
         containsnodei[i] = true;
	 break;
      }
   }
}

// Sort paths by their lengths.

for (i = 0; i < nmpaths; ++i) {
   index[i] = i + 1;
   rpathlength[i] = (double) pathlength[i];
}
Idsort.idsort_(rpathlength, index, 1, nmpaths);

nmshrtstpths[0] = 0;
nmshrtstpths[1] = 0;
for (i = 0; i < nmpaths; ++i) {
   if (containsnodei[index[i] - 1]) {
      ++nmshrtstpths[1];
   }
   ++nmshrtstpths[0];

   if (i + 1 < nmpaths) {
      if (pathlength[index[i] - 1] < pathlength[index[i + 1] - 1]) {
         break;
      }
   }
}

return;
}
