/* Update the global authorizations table.  This script is to be run
   whenever a node update's its local authorizations.  This script
   implements the GLAD access control system using its
   "strictly conservative" strategy: Procedure SC-strategy
   (Figure 3 in Castano et al. (1997). */

use members;

-- Count the number of nodes.

set @nmnodes = (select count(nodeID) from node_information);

-- Delete old global authorizations.

delete from member_authorizations where nodeID = 0;

-- Select member privileges that were given to them by all nodes.

create temporary table n (
   memberID bigint unsigned not null default 0,
   privilegeID int unsigned not null default 0,
   nmgivenpriv int unsigned not null default 0,
   nodeID int unsigned not null default 0);

insert into n (memberID, privilegeID, nmgivenpriv)
   select memberID, privilegeID, count(*) as nmgivenpriv
   from member_authorizations
   group by memberID, privilegeID
   having nmgivenpriv = @nmnodes;

delete from n where memberID = 0;

update n
   set nodeID = 0;

-- Replace the old global authorizations table with these new ones.

set foreign_key_checks=0;
insert into member_authorizations (memberID, nodeID, privilegeID)
   select memberID, nodeID, privilegeID from n;

select 'Updated member_authorizations table:';
select * from member_authorizations;
