This example uses CTE and COUNT functions with the OVER clause to return those departments which have more than 5 employees at least.

WITH CTE as
(
SELECT distinct Name DeptName 
       ,COUNT(ed.BusinessEntityID) OVER (PARTITION BY ed.DepartmentID) AS EmployeesPerDeptCnt
    FROM HumanResources.EmployeePayHistory ep 
JOIN HumanResources.EmployeeDepartmentHistory ed
     ON ep.BusinessEntityID = ed.BusinessEntityID  
JOIN HumanResources.Department AS d  
ON d.DepartmentID = ed.DepartmentID
WHERE ed.EndDate IS NULL  
)
select * from CTE where EmployeesPerDeptCnt >5

SELECT *
FROM products
WHERE product_line in (SELECT product_line
                   FROM products
               GROUP BY product_line
   HAVING COUNT(product_code)>=3);

SELECT species_id, COUNT(species_id) AS occurrences
FROM surveys
GROUP BY species_id
HAVING occurrences > 10;

---------------------------------------

set @nmnodes = (select count(nodeID) from node_information);
select memberID, privilegeID, count(m.memberID) as nmgivenpriv
from mameber_authorizations m
having nmgivenpriv = @nmnodes
group by memberID, privilegeID;

