# Submits a query to all confederation nodes.

param ($queryfilename)

# User credentials are the same for all nodes.

$user = 'username'
$pass = 'password'

# Define confederation node URLs.

$nodeURL = @(
'123.0'
'123.1'
)
$nmnodes = $nodeURL.length

# Names of generic tables used by nodes.  Index 0 on the first dimension
# is the generic name.

$nmtables = 2
$tablename = New-Object 'string[,]' ($nmnodes + 1), $nmtables
$tablename[0,0] = 'players'
$tablename[1,0] = 'suspect'
$tablename[2,0] = 'person'

$tablename[0,1] = 'guns'
$tablename[1,1] = 'weapon'
$tablename[2,1] = 'firearm'

# Names of generic columns used by nodes.

$nmcolumns = 2
$columnname = New-Object 'string[,]' ($nmnodes + 1), $nmcolumns
$columnname[0,0] = 'firstname'
$columnname[1,0] = 'first'
$columnname[2,0] = 'givenname'

$columnname[0,1] = 'lastname'
$columnname[1,1] = 'last'
$columnname[2,1] = 'surname'

# ----------------------------------------------------------------

function Main {

$query = get-content($queryfilename)
$query

# Loop over nodes.

for ($i=0; $i -lt $nodeURL.length; $i++) {

   # Replace generic table and column names with those used by this node.

   $nodequery = $query

   # Substitute node table and column names for the generic ones.

   $cnode = $i + 1
   for ($j=0; $j -lt $nmtables; $j++) {
      $nodequery = $nodequery -replace $tablename[0,$j],`
                                       $tablename[$cnode,$j]
   }
   for ($j=0; $j -lt $nmcolumns; $j++) {
      $nodequery = $nodequery -replace $columnname[0,$j],`
                                       $columnname[$cnode,$j]
   }

   # Look up this node's URL and submit the remote SQL query.

   "fedquery.ps1: Running $queryfilename on node $j"

<# Start-Process "./mysql -h$($nodeURL[$i]) -u$($user) -p$($pass)"`
      -RedirectStandardInput $nodequery`
      -RedirectStandardOutput "./temp.txt"`
      -NoNewWindow -Wait
#>
   # Write output to stdout.

#  $Result = Get-Content "./temp.txt"
   $i
   $nodequery
}
}

. Main
