# Updates GLAD authorizations and emails these in an SQL script
# file to each node.  This emailed script file, when run on each node,
# updates database privileges of all members on that node.

# Logistics node root credentials.

$user = 'root'
$passwrd = 'aaa22!?zzzzZ'

# ----------------------------------------------------------------

function Main {

# Run the SQL query sent by a single node that updates, as directed,
# database privileges on that node for one or more members.

" "
"***** update_glad.ps1: Running required_changes.sql *****"

$queryfilename = "requiredchanges.sql"
$processOptions = @{
FilePath = "`"c:\Program Files\MySQL\MySQL Server 8.0\bin\mysql`""
ArgumentList = "-u$($user) -p$($passwrd) -v -N"
WorkingDirectory = "c:/polbio/wtsdbfiles"
RedirectStandardInput = $queryfilename 
RedirectStandardOutput = "temp1.txt"
NoNewWindow = $true
Wait = $true
}
Start-Process @processOptions

Get-Content "./temp1.txt"
#
# Next, run an SQL query that computes a set of updated GLAD
# authorizations.

" "
"***** update_glad.ps1: Running compute_glad.sql *****"

$queryfilename = "computeglad.sql"
$processOptions = @{
FilePath = "`"c:\Program Files\MySQL\MySQL Server 8.0\bin\mysql`""
ArgumentList = "-u$($user) -p$($passwrd) -v -N"
WorkingDirectory = "c:/polbio/wtsdbfiles"
RedirectStandardInput = $queryfilename 
RedirectStandardOutput = "temp2.txt"
NoNewWindow = $true
Wait = $true
}
Start-Process @processOptions

Get-Content "./temp2.txt"

# Next, run another SQL query to create an SQL query that, when run on
# a node, updates database privileges of all members according to their GLAD
# authorizations.  Create this SQL query file by reading the updated
# table of user authorizations that was created by the query, above.

" "
"***** update_glad.ps1: Running update_privileges.sql *****"

$queryfilename = "updateprivileges.sql"
$processOptions = @{
FilePath = "`"c:\Program Files\MySQL\MySQL Server 8.0\bin\mysql`""
ArgumentList = "-u$($user) -p$($passwrd) -v -N"
WorkingDirectory = "c:/polbio/wtsdbfiles"
RedirectStandardInput = $queryfilename 
RedirectStandardOutput = "temp3.txt"
NoNewWindow = $true
Wait = $true
}
Start-Process @processOptions

$result = Get-Content "./temp3.txt"

# Remove dashed lines.

$result1 = $result | Where-Object {(-not $_.Contains('-----')) -and
                                   (-not $_.Contains('concat'))}

$outsql = $result1 | Where-Object {($_.Contains('revoke all')) -or
                                   ($_.Contains('grant')) -or
                                   ($_.Contains('show')) -or
                                   ($_.Contains('flush')) -or
                                   ($_.Contains('GRANT'))}

#$outsql = $outsql.Replace("`"urlToImage`":`"http"," ")
$outsql = $outsql.Replace("%``","%``;")
$outsql = $outsql.Replace("privileges","privileges;")

$outsql | Set-Content "./globalprivileges.sql"

" "
"***** globalprivileges.sql *****"

Get-Content "./globalprivileges.sql"

# Email this SQL script file to each node by running
# "updateemail.ps1" from this PowerShell script.
# First, define confederation node URLs.

" "
"***** update_glad.ps1: Running updateemail.ps1 *****"

$nodeURL = @(
'123.0'
'123.1'
)
$nmnodes = $nodeURL.length

# Loop over nodes.

for ($i=0; $i -lt $nodeURL.length; $i++) {
#  powershell ./updateemail.ps1 nodeURL[i] "globalprivileges.sql"
}
}

. Main
